//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter dcOffCorr_0_xTx_w           = 24;
  parameter dcOffCorr_0_xRx_w           = 24;
  parameter dcOffCorr_0_attnDb_w        = 7;

  // Outputs
  parameter dcOffCorr_0_yTx_w           = 24;
  parameter dcOffCorr_0_yRx_w           = 24;

  // Input control lines
  parameter dcOffCorr_0_run1_w          = 2;

  // Output control lines

  // Eregs
  parameter dcOffCorr_0_corrOn_w        = 1;
  parameter dcOffCorr_0_corrOn_r        = 0;
  parameter dcOffCorr_0_corrOn_s        = 0;
  parameter dcOffCorr_0_txDcOffRe_w     = 12;
  parameter dcOffCorr_0_txDcOffRe_r     = 0;
  parameter dcOffCorr_0_txDcOffRe_s     = 0;
  parameter dcOffCorr_0_txDcOffIm_w     = 12;
  parameter dcOffCorr_0_txDcOffIm_r     = 0;
  parameter dcOffCorr_0_txDcOffIm_s     = 0;

  // Parameters
  parameter dcOffCorr_0_w               = 12;

  // Iregs
  parameter dcOffCorr_0_yRe_w           = 12;
  parameter dcOffCorr_0_yRe_n           = 1;
  parameter dcOffCorr_0_yRe_m           = `CLOG2(1);
  parameter dcOffCorr_0_yIm_w           = 12;
  parameter dcOffCorr_0_yIm_n           = 1;
  parameter dcOffCorr_0_yIm_m           = `CLOG2(1);

  // Single ported memories

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam dcOffCorr_0.xTx_w           = dcOffCorr_0_xTx_w;
  defparam dcOffCorr_0.xRx_w           = dcOffCorr_0_xRx_w;
  defparam dcOffCorr_0.attnDb_w        = dcOffCorr_0_attnDb_w;
  defparam dcOffCorr_0.yTx_w           = dcOffCorr_0_yTx_w;
  defparam dcOffCorr_0.yRx_w           = dcOffCorr_0_yRx_w;
  defparam dcOffCorr_0.run1_w          = dcOffCorr_0_run1_w;
  defparam dcOffCorr_0.corrOn_w        = dcOffCorr_0_corrOn_w;
  defparam dcOffCorr_0.corrOn_r        = dcOffCorr_0_corrOn_r;
  defparam dcOffCorr_0.corrOn_s        = dcOffCorr_0_corrOn_s;
  defparam dcOffCorr_0.txDcOffRe_w     = dcOffCorr_0_txDcOffRe_w;
  defparam dcOffCorr_0.txDcOffRe_r     = dcOffCorr_0_txDcOffRe_r;
  defparam dcOffCorr_0.txDcOffRe_s     = dcOffCorr_0_txDcOffRe_s;
  defparam dcOffCorr_0.txDcOffIm_w     = dcOffCorr_0_txDcOffIm_w;
  defparam dcOffCorr_0.txDcOffIm_r     = dcOffCorr_0_txDcOffIm_r;
  defparam dcOffCorr_0.txDcOffIm_s     = dcOffCorr_0_txDcOffIm_s;
  defparam dcOffCorr_0.w               = dcOffCorr_0_w;
  defparam dcOffCorr_0.yRe_w           = dcOffCorr_0_yRe_w;
  defparam dcOffCorr_0.yRe_n           = dcOffCorr_0_yRe_n;
  defparam dcOffCorr_0.yRe_m           = dcOffCorr_0_yRe_m;
  defparam dcOffCorr_0.yIm_w           = dcOffCorr_0_yIm_w;
  defparam dcOffCorr_0.yIm_n           = dcOffCorr_0_yIm_n;
  defparam dcOffCorr_0.yIm_m           = dcOffCorr_0_yIm_m;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module
  parameter R_dcOffCorr_0_corrOn                                         = 0;
  defparam  dcOffCorr_0.R_corrOn                                         = R_dcOffCorr_0_corrOn;
  parameter R_dcOffCorr_0_txDcOffRe                                      = 1;
  defparam  dcOffCorr_0.R_txDcOffRe                                      = R_dcOffCorr_0_txDcOffRe;
  parameter R_dcOffCorr_0_txDcOffIm                                      = 2;
  defparam  dcOffCorr_0.R_txDcOffIm                                      = R_dcOffCorr_0_txDcOffIm;
  parameter R_dcOffCorr_0_lut_rxDcOff_wrAdr                              = 3;
  defparam  dcOffCorr_0.R_lut_rxDcOff_wrAdr                              = R_dcOffCorr_0_lut_rxDcOff_wrAdr;
  parameter R_dcOffCorr_0_lut_rxDcOff_wrDatHi                            = 4;
  defparam  dcOffCorr_0.R_lut_rxDcOff_wrDatHi                            = R_dcOffCorr_0_lut_rxDcOff_wrDatHi;
  parameter R_dcOffCorr_0_lut_rxDcOff_wrDatLo                            = 5;
  defparam  dcOffCorr_0.R_lut_rxDcOff_wrDatLo                            = R_dcOffCorr_0_lut_rxDcOff_wrDatLo;
  parameter R_dcOffCorr_0_lut_rxDcOff_simInit                            = 6;
  defparam  dcOffCorr_0.R_lut_rxDcOff_simInit                            = R_dcOffCorr_0_lut_rxDcOff_simInit;

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire             [dcOffCorr_0_yTx_w-1:0]  dcOffCorr_0_yTx;
  wire                                      dcOffCorr_0_yTx_or;
  wire                                      dcOffCorr_0_yTx_ff;
  wire                                      dcOffCorr_0_yTx_we;

  wire             [dcOffCorr_0_yRx_w-1:0]  dcOffCorr_0_yRx;
  wire                                      dcOffCorr_0_yRx_or;
  wire                                      dcOffCorr_0_yRx_ff;
  wire                                      dcOffCorr_0_yRx_we;

  wire             [dcOffCorr_0_xTx_w-1:0]  dcOffCorr_0_xTx;
  wire                                      dcOffCorr_0_xTx_ir;
  wire                                      dcOffCorr_0_xTx_fe;
  wire                                      dcOffCorr_0_xTx_re;

  wire             [dcOffCorr_0_xRx_w-1:0]  dcOffCorr_0_xRx;
  wire                                      dcOffCorr_0_xRx_ir;
  wire                                      dcOffCorr_0_xRx_fe;
  wire                                      dcOffCorr_0_xRx_re;

  wire          [dcOffCorr_0_attnDb_w-1:0]  dcOffCorr_0_attnDb;
  wire                                      dcOffCorr_0_attnDb_ir;
  wire                                      dcOffCorr_0_attnDb_fe;
  wire                                      dcOffCorr_0_attnDb_re;

  wire            [dcOffCorr_0_run1_w-1:0]  dcOffCorr_0_run1;

  wire                                      dcOffCorr_0_regWe;
  wire                                      dcOffCorr_0_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  dcOffCorr dcOffCorr_0(dcOffCorr_0_yTx, dcOffCorr_0_yTx_or, dcOffCorr_0_yTx_ff, dcOffCorr_0_yTx_we,
                        dcOffCorr_0_yRx, dcOffCorr_0_yRx_or, dcOffCorr_0_yRx_ff, dcOffCorr_0_yRx_we,
                        dcOffCorr_0_xTx, dcOffCorr_0_xTx_ir, dcOffCorr_0_xTx_fe, dcOffCorr_0_xTx_re, 
                        dcOffCorr_0_xRx, dcOffCorr_0_xRx_ir, dcOffCorr_0_xRx_fe, dcOffCorr_0_xRx_re, 
                        dcOffCorr_0_attnDb, dcOffCorr_0_attnDb_ir, dcOffCorr_0_attnDb_fe, dcOffCorr_0_attnDb_re, 
                        dcOffCorr_0_run1, 
                        regBus, regWe, regRe, dcOffCorr_0_regWe, dcOffCorr_0_regRe, clk, clk2, reset);


//==============================================================================
