//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter dataBuf_dcfTx_x_w             = 16;

  // Outputs
  parameter dataBuf_dcfTx_y_w             = 16;

  // Input control lines

  // Output control lines

  // Eregs
  parameter dataBuf_dcfTx_run1_w          = 3;
  parameter dataBuf_dcfTx_run1_r          = 0;
  parameter dataBuf_dcfTx_run1_s          = 0;
  parameter dataBuf_dcfTx_datAdr_w        = WlanDcfAdrWidthTx_C;
  parameter dataBuf_dcfTx_datAdr_r        = 0;
  parameter dataBuf_dcfTx_datAdr_s        = 0;
  parameter dataBuf_dcfTx_datVal_w        = 16;
  parameter dataBuf_dcfTx_datVal_r        = 0;
  parameter dataBuf_dcfTx_datVal_s        = 0;

  // Parameters
  parameter dataBuf_dcfTx_w               = 16;
  parameter dataBuf_dcfTx_m               = WlanDcfAdrWidthTx_C;
  parameter dataBuf_dcfTx_ModeReset       = 0;
  parameter dataBuf_dcfTx_ModeWrReg       = 1;
  parameter dataBuf_dcfTx_ModeWrPort      = 2;
  parameter dataBuf_dcfTx_ModeRdReg       = 5;
  parameter dataBuf_dcfTx_ModeRdPort      = 6;
  parameter dataBuf_dcfTx_ModeRdPortMult  = 7;

  // Iregs

  // Single ported memories
  parameter dataBuf_dcfTx_buf0_w          = 16;
  parameter dataBuf_dcfTx_buf0_n          = WlanDcfBufLenTx_C;
  parameter dataBuf_dcfTx_buf0_m          = `CLOG2(WlanDcfBufLenTx_C);

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam dataBuf_dcfTx.x_w             = dataBuf_dcfTx_x_w;
  defparam dataBuf_dcfTx.y_w             = dataBuf_dcfTx_y_w;
  defparam dataBuf_dcfTx.run1_w          = dataBuf_dcfTx_run1_w;
  defparam dataBuf_dcfTx.run1_r          = dataBuf_dcfTx_run1_r;
  defparam dataBuf_dcfTx.run1_s          = dataBuf_dcfTx_run1_s;
  defparam dataBuf_dcfTx.datAdr_w        = dataBuf_dcfTx_datAdr_w;
  defparam dataBuf_dcfTx.datAdr_r        = dataBuf_dcfTx_datAdr_r;
  defparam dataBuf_dcfTx.datAdr_s        = dataBuf_dcfTx_datAdr_s;
  defparam dataBuf_dcfTx.datVal_w        = dataBuf_dcfTx_datVal_w;
  defparam dataBuf_dcfTx.datVal_r        = dataBuf_dcfTx_datVal_r;
  defparam dataBuf_dcfTx.datVal_s        = dataBuf_dcfTx_datVal_s;
  defparam dataBuf_dcfTx.w               = dataBuf_dcfTx_w;
  defparam dataBuf_dcfTx.m               = dataBuf_dcfTx_m;
  defparam dataBuf_dcfTx.ModeReset       = dataBuf_dcfTx_ModeReset;
  defparam dataBuf_dcfTx.ModeWrReg       = dataBuf_dcfTx_ModeWrReg;
  defparam dataBuf_dcfTx.ModeWrPort      = dataBuf_dcfTx_ModeWrPort;
  defparam dataBuf_dcfTx.ModeRdReg       = dataBuf_dcfTx_ModeRdReg;
  defparam dataBuf_dcfTx.ModeRdPort      = dataBuf_dcfTx_ModeRdPort;
  defparam dataBuf_dcfTx.ModeRdPortMult  = dataBuf_dcfTx_ModeRdPortMult;
  defparam dataBuf_dcfTx.buf0_w          = dataBuf_dcfTx_buf0_w;
  defparam dataBuf_dcfTx.buf0_n          = dataBuf_dcfTx_buf0_n;
  defparam dataBuf_dcfTx.buf0_m          = dataBuf_dcfTx_buf0_m;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module
  parameter R_dataBuf_dcfTx_run1                                         = 0;
  defparam  dataBuf_dcfTx.R_run1                                         = R_dataBuf_dcfTx_run1;
  parameter R_dataBuf_dcfTx_datAdr                                       = 1;
  defparam  dataBuf_dcfTx.R_datAdr                                       = R_dataBuf_dcfTx_datAdr;
  parameter R_dataBuf_dcfTx_datVal                                       = 2;
  defparam  dataBuf_dcfTx.R_datVal                                       = R_dataBuf_dcfTx_datVal;

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire             [dataBuf_dcfTx_y_w-1:0]  dataBuf_dcfTx_y;
  wire                                      dataBuf_dcfTx_y_or;
  wire                                      dataBuf_dcfTx_y_ff;
  wire                                      dataBuf_dcfTx_y_we;

  wire             [dataBuf_dcfTx_x_w-1:0]  dataBuf_dcfTx_x;
  wire                                      dataBuf_dcfTx_x_ir;
  wire                                      dataBuf_dcfTx_x_fe;
  wire                                      dataBuf_dcfTx_x_re;

  wire                                      dataBuf_dcfTx_regWe;
  wire                                      dataBuf_dcfTx_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  dataBuf dataBuf_dcfTx(dataBuf_dcfTx_y, dataBuf_dcfTx_y_or, dataBuf_dcfTx_y_ff, dataBuf_dcfTx_y_we,
                        dataBuf_dcfTx_x, dataBuf_dcfTx_x_ir, dataBuf_dcfTx_x_fe, dataBuf_dcfTx_x_re, 
                        regBus, regWe, regRe, dataBuf_dcfTx_regWe, dataBuf_dcfTx_regRe, clk, clk2, reset);


//==============================================================================
