//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter dataBuf_dcfRx_x_w             = 16;

  // Outputs
  parameter dataBuf_dcfRx_y_w             = 16;

  // Input control lines

  // Output control lines

  // Eregs
  parameter dataBuf_dcfRx_run1_w          = 3;
  parameter dataBuf_dcfRx_run1_r          = 0;
  parameter dataBuf_dcfRx_run1_s          = 0;
  parameter dataBuf_dcfRx_datAdr_w        = WlanDcfAdrWidthRx_C;
  parameter dataBuf_dcfRx_datAdr_r        = 0;
  parameter dataBuf_dcfRx_datAdr_s        = 0;
  parameter dataBuf_dcfRx_datVal_w        = 16;
  parameter dataBuf_dcfRx_datVal_r        = 0;
  parameter dataBuf_dcfRx_datVal_s        = 0;

  // Parameters
  parameter dataBuf_dcfRx_w               = 16;
  parameter dataBuf_dcfRx_m               = WlanDcfAdrWidthRx_C;
  parameter dataBuf_dcfRx_ModeReset       = 0;
  parameter dataBuf_dcfRx_ModeWrReg       = 1;
  parameter dataBuf_dcfRx_ModeWrPort      = 2;
  parameter dataBuf_dcfRx_ModeRdReg       = 5;
  parameter dataBuf_dcfRx_ModeRdPort      = 6;
  parameter dataBuf_dcfRx_ModeRdPortMult  = 7;

  // Iregs

  // Single ported memories
  parameter dataBuf_dcfRx_buf0_w          = 16;
  parameter dataBuf_dcfRx_buf0_n          = WlanDcfBufLenRx_C;
  parameter dataBuf_dcfRx_buf0_m          = `CLOG2(WlanDcfBufLenRx_C);

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam dataBuf_dcfRx.x_w             = dataBuf_dcfRx_x_w;
  defparam dataBuf_dcfRx.y_w             = dataBuf_dcfRx_y_w;
  defparam dataBuf_dcfRx.run1_w          = dataBuf_dcfRx_run1_w;
  defparam dataBuf_dcfRx.run1_r          = dataBuf_dcfRx_run1_r;
  defparam dataBuf_dcfRx.run1_s          = dataBuf_dcfRx_run1_s;
  defparam dataBuf_dcfRx.datAdr_w        = dataBuf_dcfRx_datAdr_w;
  defparam dataBuf_dcfRx.datAdr_r        = dataBuf_dcfRx_datAdr_r;
  defparam dataBuf_dcfRx.datAdr_s        = dataBuf_dcfRx_datAdr_s;
  defparam dataBuf_dcfRx.datVal_w        = dataBuf_dcfRx_datVal_w;
  defparam dataBuf_dcfRx.datVal_r        = dataBuf_dcfRx_datVal_r;
  defparam dataBuf_dcfRx.datVal_s        = dataBuf_dcfRx_datVal_s;
  defparam dataBuf_dcfRx.w               = dataBuf_dcfRx_w;
  defparam dataBuf_dcfRx.m               = dataBuf_dcfRx_m;
  defparam dataBuf_dcfRx.ModeReset       = dataBuf_dcfRx_ModeReset;
  defparam dataBuf_dcfRx.ModeWrReg       = dataBuf_dcfRx_ModeWrReg;
  defparam dataBuf_dcfRx.ModeWrPort      = dataBuf_dcfRx_ModeWrPort;
  defparam dataBuf_dcfRx.ModeRdReg       = dataBuf_dcfRx_ModeRdReg;
  defparam dataBuf_dcfRx.ModeRdPort      = dataBuf_dcfRx_ModeRdPort;
  defparam dataBuf_dcfRx.ModeRdPortMult  = dataBuf_dcfRx_ModeRdPortMult;
  defparam dataBuf_dcfRx.buf0_w          = dataBuf_dcfRx_buf0_w;
  defparam dataBuf_dcfRx.buf0_n          = dataBuf_dcfRx_buf0_n;
  defparam dataBuf_dcfRx.buf0_m          = dataBuf_dcfRx_buf0_m;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module
  parameter R_dataBuf_dcfRx_run1                                         = 0;
  defparam  dataBuf_dcfRx.R_run1                                         = R_dataBuf_dcfRx_run1;
  parameter R_dataBuf_dcfRx_datAdr                                       = 1;
  defparam  dataBuf_dcfRx.R_datAdr                                       = R_dataBuf_dcfRx_datAdr;
  parameter R_dataBuf_dcfRx_datVal                                       = 2;
  defparam  dataBuf_dcfRx.R_datVal                                       = R_dataBuf_dcfRx_datVal;

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire             [dataBuf_dcfRx_y_w-1:0]  dataBuf_dcfRx_y;
  wire                                      dataBuf_dcfRx_y_or;
  wire                                      dataBuf_dcfRx_y_ff;
  wire                                      dataBuf_dcfRx_y_we;

  wire             [dataBuf_dcfRx_x_w-1:0]  dataBuf_dcfRx_x;
  wire                                      dataBuf_dcfRx_x_ir;
  wire                                      dataBuf_dcfRx_x_fe;
  wire                                      dataBuf_dcfRx_x_re;

  wire                                      dataBuf_dcfRx_regWe;
  wire                                      dataBuf_dcfRx_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  dataBuf dataBuf_dcfRx(dataBuf_dcfRx_y, dataBuf_dcfRx_y_or, dataBuf_dcfRx_y_ff, dataBuf_dcfRx_y_we,
                        dataBuf_dcfRx_x, dataBuf_dcfRx_x_ir, dataBuf_dcfRx_x_fe, dataBuf_dcfRx_x_re, 
                        regBus, regWe, regRe, dataBuf_dcfRx_regWe, dataBuf_dcfRx_regRe, clk, clk2, reset);


//==============================================================================
