//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter dataBufX32_iqBuf_x_w             = 24;

  // Outputs
  parameter dataBufX32_iqBuf_y_w             = 24;

  // Input control lines

  // Output control lines

  // Eregs
  parameter dataBufX32_iqBuf_run1_w          = 3;
  parameter dataBufX32_iqBuf_run1_r          = 0;
  parameter dataBufX32_iqBuf_run1_s          = 0;
  parameter dataBufX32_iqBuf_datAdr_w        = WlanIqBufAdrWidth_C;
  parameter dataBufX32_iqBuf_datAdr_r        = 0;
  parameter dataBufX32_iqBuf_datAdr_s        = 0;
  parameter dataBufX32_iqBuf_datValLo_w      = 16;
  parameter dataBufX32_iqBuf_datValLo_r      = 0;
  parameter dataBufX32_iqBuf_datValLo_s      = 0;
  parameter dataBufX32_iqBuf_datValHi_w      = 16;
  parameter dataBufX32_iqBuf_datValHi_r      = 0;
  parameter dataBufX32_iqBuf_datValHi_s      = 0;

  // Parameters
  parameter dataBufX32_iqBuf_w               = 24;
  parameter dataBufX32_iqBuf_m               = WlanIqBufAdrWidth_C;
  parameter dataBufX32_iqBuf_ModeReset       = 0;
  parameter dataBufX32_iqBuf_ModeWrReg       = 1;
  parameter dataBufX32_iqBuf_ModeWrPort      = 2;
  parameter dataBufX32_iqBuf_ModeRdReg       = 5;
  parameter dataBufX32_iqBuf_ModeRdPort      = 6;
  parameter dataBufX32_iqBuf_ModeRdPortMult  = 7;

  // Iregs

  // Single ported memories
  parameter dataBufX32_iqBuf_buf0_w          = 24;
  parameter dataBufX32_iqBuf_buf0_n          = WlanIqBufNumSmpl_C;
  parameter dataBufX32_iqBuf_buf0_m          = `CLOG2(WlanIqBufNumSmpl_C);

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam dataBufX32_iqBuf.x_w             = dataBufX32_iqBuf_x_w;
  defparam dataBufX32_iqBuf.y_w             = dataBufX32_iqBuf_y_w;
  defparam dataBufX32_iqBuf.run1_w          = dataBufX32_iqBuf_run1_w;
  defparam dataBufX32_iqBuf.run1_r          = dataBufX32_iqBuf_run1_r;
  defparam dataBufX32_iqBuf.run1_s          = dataBufX32_iqBuf_run1_s;
  defparam dataBufX32_iqBuf.datAdr_w        = dataBufX32_iqBuf_datAdr_w;
  defparam dataBufX32_iqBuf.datAdr_r        = dataBufX32_iqBuf_datAdr_r;
  defparam dataBufX32_iqBuf.datAdr_s        = dataBufX32_iqBuf_datAdr_s;
  defparam dataBufX32_iqBuf.datValLo_w      = dataBufX32_iqBuf_datValLo_w;
  defparam dataBufX32_iqBuf.datValLo_r      = dataBufX32_iqBuf_datValLo_r;
  defparam dataBufX32_iqBuf.datValLo_s      = dataBufX32_iqBuf_datValLo_s;
  defparam dataBufX32_iqBuf.datValHi_w      = dataBufX32_iqBuf_datValHi_w;
  defparam dataBufX32_iqBuf.datValHi_r      = dataBufX32_iqBuf_datValHi_r;
  defparam dataBufX32_iqBuf.datValHi_s      = dataBufX32_iqBuf_datValHi_s;
  defparam dataBufX32_iqBuf.w               = dataBufX32_iqBuf_w;
  defparam dataBufX32_iqBuf.m               = dataBufX32_iqBuf_m;
  defparam dataBufX32_iqBuf.ModeReset       = dataBufX32_iqBuf_ModeReset;
  defparam dataBufX32_iqBuf.ModeWrReg       = dataBufX32_iqBuf_ModeWrReg;
  defparam dataBufX32_iqBuf.ModeWrPort      = dataBufX32_iqBuf_ModeWrPort;
  defparam dataBufX32_iqBuf.ModeRdReg       = dataBufX32_iqBuf_ModeRdReg;
  defparam dataBufX32_iqBuf.ModeRdPort      = dataBufX32_iqBuf_ModeRdPort;
  defparam dataBufX32_iqBuf.ModeRdPortMult  = dataBufX32_iqBuf_ModeRdPortMult;
  defparam dataBufX32_iqBuf.buf0_w          = dataBufX32_iqBuf_buf0_w;
  defparam dataBufX32_iqBuf.buf0_n          = dataBufX32_iqBuf_buf0_n;
  defparam dataBufX32_iqBuf.buf0_m          = dataBufX32_iqBuf_buf0_m;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module
  parameter R_dataBufX32_iqBuf_run1                                      = 0;
  defparam  dataBufX32_iqBuf.R_run1                                      = R_dataBufX32_iqBuf_run1;
  parameter R_dataBufX32_iqBuf_datAdr                                    = 1;
  defparam  dataBufX32_iqBuf.R_datAdr                                    = R_dataBufX32_iqBuf_datAdr;
  parameter R_dataBufX32_iqBuf_datValLo                                  = 2;
  defparam  dataBufX32_iqBuf.R_datValLo                                  = R_dataBufX32_iqBuf_datValLo;
  parameter R_dataBufX32_iqBuf_datValHi                                  = 3;
  defparam  dataBufX32_iqBuf.R_datValHi                                  = R_dataBufX32_iqBuf_datValHi;

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire          [dataBufX32_iqBuf_y_w-1:0]  dataBufX32_iqBuf_y;
  wire                                      dataBufX32_iqBuf_y_or;
  wire                                      dataBufX32_iqBuf_y_ff;
  wire                                      dataBufX32_iqBuf_y_we;

  wire          [dataBufX32_iqBuf_x_w-1:0]  dataBufX32_iqBuf_x;
  wire                                      dataBufX32_iqBuf_x_ir;
  wire                                      dataBufX32_iqBuf_x_fe;
  wire                                      dataBufX32_iqBuf_x_re;

  wire                                      dataBufX32_iqBuf_regWe;
  wire                                      dataBufX32_iqBuf_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  dataBufX32 dataBufX32_iqBuf(dataBufX32_iqBuf_y, dataBufX32_iqBuf_y_or, dataBufX32_iqBuf_y_ff, dataBufX32_iqBuf_y_we,
                              dataBufX32_iqBuf_x, dataBufX32_iqBuf_x_ir, dataBufX32_iqBuf_x_fe, dataBufX32_iqBuf_x_re, 
                              regBus, regWe, regRe, dataBufX32_iqBuf_regWe, dataBufX32_iqBuf_regRe, clk, clk2, reset);


//==============================================================================
