//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter cutN_20c4_x_w             = 20;

  // Outputs
  parameter cutN_20c4_y_w             = 20;

  // Input control lines
  parameter cutN_20c4_run1_w          = 1;

  // Output control lines

  // Eregs
  parameter cutN_20c4_numCut_w        = 4;
  parameter cutN_20c4_numCut_r        = 0;
  parameter cutN_20c4_numCut_s        = 0;

  // Parameters
  parameter cutN_20c4_w               = 20;

  // Iregs
  parameter cutN_20c4_cntCut_w        = 4;
  parameter cutN_20c4_cntCut_n        = 1;
  parameter cutN_20c4_cntCut_m        = `CLOG2(1);

  // Single ported memories

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam cutN_20c4.x_w             = cutN_20c4_x_w;
  defparam cutN_20c4.y_w             = cutN_20c4_y_w;
  defparam cutN_20c4.run1_w          = cutN_20c4_run1_w;
  defparam cutN_20c4.numCut_w        = cutN_20c4_numCut_w;
  defparam cutN_20c4.numCut_r        = cutN_20c4_numCut_r;
  defparam cutN_20c4.numCut_s        = cutN_20c4_numCut_s;
  defparam cutN_20c4.w               = cutN_20c4_w;
  defparam cutN_20c4.cntCut_w        = cutN_20c4_cntCut_w;
  defparam cutN_20c4.cntCut_n        = cutN_20c4_cntCut_n;
  defparam cutN_20c4.cntCut_m        = cutN_20c4_cntCut_m;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module
  parameter R_cutN_20c4_numCut                                           = 0;
  defparam  cutN_20c4.R_numCut                                           = R_cutN_20c4_numCut;

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire                 [cutN_20c4_y_w-1:0]  cutN_20c4_y;
  wire                                      cutN_20c4_y_or;
  wire                                      cutN_20c4_y_ff;
  wire                                      cutN_20c4_y_we;

  wire                 [cutN_20c4_x_w-1:0]  cutN_20c4_x;
  wire                                      cutN_20c4_x_ir;
  wire                                      cutN_20c4_x_fe;
  wire                                      cutN_20c4_x_re;

  wire              [cutN_20c4_run1_w-1:0]  cutN_20c4_run1;

  wire                                      cutN_20c4_regWe;
  wire                                      cutN_20c4_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  cutN cutN_20c4(cutN_20c4_y, cutN_20c4_y_or, cutN_20c4_y_ff, cutN_20c4_y_we,
                 cutN_20c4_x, cutN_20c4_x_ir, cutN_20c4_x_fe, cutN_20c4_x_re, 
                 cutN_20c4_run1, 
                 regBus, regWe, regRe, cutN_20c4_regWe, cutN_20c4_regRe, clk, clk2, reset);


//==============================================================================
