//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter ctfe_0_x_w             = 10;

  // Outputs
  parameter ctfe_0_yAbs_w          = 8;
  parameter ctfe_0_yPh_w           = 8;

  // Input control lines
  parameter ctfe_0_run1_w          = 1;

  // Output control lines

  // Eregs

  // Parameters
  parameter ctfe_0_wx              = 5;
  parameter ctfe_0_wc              = 8;
  parameter ctfe_0_wy              = 8;

  // Iregs

  // Single ported memories

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam ctfe_0.x_w             = ctfe_0_x_w;
  defparam ctfe_0.yAbs_w          = ctfe_0_yAbs_w;
  defparam ctfe_0.yPh_w           = ctfe_0_yPh_w;
  defparam ctfe_0.run1_w          = ctfe_0_run1_w;
  defparam ctfe_0.wx              = ctfe_0_wx;
  defparam ctfe_0.wc              = ctfe_0_wc;
  defparam ctfe_0.wy              = ctfe_0_wy;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module
  parameter R_ctfe_0_ctfeCordic_0_thr                                    = 0;
  defparam  ctfe_0.R_ctfeCordic_0_thr                                    = R_ctfe_0_ctfeCordic_0_thr;

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire                 [ctfe_0_yAbs_w-1:0]  ctfe_0_yAbs;
  wire                                      ctfe_0_yAbs_or;
  wire                                      ctfe_0_yAbs_ff;
  wire                                      ctfe_0_yAbs_we;

  wire                  [ctfe_0_yPh_w-1:0]  ctfe_0_yPh;
  wire                                      ctfe_0_yPh_or;
  wire                                      ctfe_0_yPh_ff;
  wire                                      ctfe_0_yPh_we;

  wire                    [ctfe_0_x_w-1:0]  ctfe_0_x;
  wire                                      ctfe_0_x_ir;
  wire                                      ctfe_0_x_fe;
  wire                                      ctfe_0_x_re;

  wire                 [ctfe_0_run1_w-1:0]  ctfe_0_run1;

  wire                                      ctfe_0_regWe;
  wire                                      ctfe_0_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  ctfe ctfe_0(ctfe_0_yAbs, ctfe_0_yAbs_or, ctfe_0_yAbs_ff, ctfe_0_yAbs_we,
              ctfe_0_yPh, ctfe_0_yPh_or, ctfe_0_yPh_ff, ctfe_0_yPh_we,
              ctfe_0_x, ctfe_0_x_ir, ctfe_0_x_fe, ctfe_0_x_re, 
              ctfe_0_run1, 
              regBus, regWe, regRe, ctfe_0_regWe, ctfe_0_regRe, clk, clk2, reset);


//==============================================================================
