//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter crc32x8_0_x_w             = 8;

  // Outputs
  parameter crc32x8_0_y_w             = 8;

  // Input control lines
  parameter crc32x8_0_run1_w          = 1;

  // Output control lines

  // Eregs
  parameter crc32x8_0_numBytes_w      = 12;
  parameter crc32x8_0_numBytes_r      = 0;
  parameter crc32x8_0_numBytes_s      = 0;
  parameter crc32x8_0_crcRes_w        = 1;
  parameter crc32x8_0_crcRes_r        = 0;
  parameter crc32x8_0_crcRes_s        = 0;

  // Parameters
  parameter crc32x8_0_w               = 8;
  parameter crc32x8_0_p0              = 1762451694;
  parameter crc32x8_0_p1              = 881225847;
  parameter crc32x8_0_p2              = 2552477408;
  parameter crc32x8_0_p3              = 1276238704;
  parameter crc32x8_0_p4              = 638119352;
  parameter crc32x8_0_p5              = 319059676;
  parameter crc32x8_0_p6              = 159529838;
  parameter crc32x8_0_p7              = 79764919;

  // Iregs
  parameter crc32x8_0_s_w             = 32;
  parameter crc32x8_0_s_n             = 1;
  parameter crc32x8_0_s_m             = `CLOG2(1);

  // Single ported memories

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam crc32x8_0.x_w             = crc32x8_0_x_w;
  defparam crc32x8_0.y_w             = crc32x8_0_y_w;
  defparam crc32x8_0.run1_w          = crc32x8_0_run1_w;
  defparam crc32x8_0.numBytes_w      = crc32x8_0_numBytes_w;
  defparam crc32x8_0.numBytes_r      = crc32x8_0_numBytes_r;
  defparam crc32x8_0.numBytes_s      = crc32x8_0_numBytes_s;
  defparam crc32x8_0.crcRes_w        = crc32x8_0_crcRes_w;
  defparam crc32x8_0.crcRes_r        = crc32x8_0_crcRes_r;
  defparam crc32x8_0.crcRes_s        = crc32x8_0_crcRes_s;
  defparam crc32x8_0.w               = crc32x8_0_w;
  defparam crc32x8_0.p0              = crc32x8_0_p0;
  defparam crc32x8_0.p1              = crc32x8_0_p1;
  defparam crc32x8_0.p2              = crc32x8_0_p2;
  defparam crc32x8_0.p3              = crc32x8_0_p3;
  defparam crc32x8_0.p4              = crc32x8_0_p4;
  defparam crc32x8_0.p5              = crc32x8_0_p5;
  defparam crc32x8_0.p6              = crc32x8_0_p6;
  defparam crc32x8_0.p7              = crc32x8_0_p7;
  defparam crc32x8_0.s_w             = crc32x8_0_s_w;
  defparam crc32x8_0.s_n             = crc32x8_0_s_n;
  defparam crc32x8_0.s_m             = crc32x8_0_s_m;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module
  parameter R_crc32x8_0_numBytes                                         = 0;
  defparam  crc32x8_0.R_numBytes                                         = R_crc32x8_0_numBytes;
  parameter R_crc32x8_0_crcRes                                           = 1;
  defparam  crc32x8_0.R_crcRes                                           = R_crc32x8_0_crcRes;

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire                 [crc32x8_0_y_w-1:0]  crc32x8_0_y;
  wire                                      crc32x8_0_y_or;
  wire                                      crc32x8_0_y_ff;
  wire                                      crc32x8_0_y_we;

  wire                 [crc32x8_0_x_w-1:0]  crc32x8_0_x;
  wire                                      crc32x8_0_x_ir;
  wire                                      crc32x8_0_x_fe;
  wire                                      crc32x8_0_x_re;

  wire              [crc32x8_0_run1_w-1:0]  crc32x8_0_run1;

  wire                                      crc32x8_0_regWe;
  wire                                      crc32x8_0_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  crc32x8 crc32x8_0(crc32x8_0_y, crc32x8_0_y_or, crc32x8_0_y_ff, crc32x8_0_y_we,
                    crc32x8_0_x, crc32x8_0_x_ir, crc32x8_0_x_fe, crc32x8_0_x_re, 
                    crc32x8_0_run1, 
                    regBus, regWe, regRe, crc32x8_0_regWe, crc32x8_0_regRe, clk, clk2, reset);


//==============================================================================
