//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter c16To8_0_x_w             = 16;

  // Outputs
  parameter c16To8_0_y_w             = 8;

  // Input control lines

  // Output control lines

  // Eregs
  parameter c16To8_0_run1_w          = 1;
  parameter c16To8_0_run1_r          = 0;
  parameter c16To8_0_run1_s          = 0;
  parameter c16To8_0_nByte_w         = 12;
  parameter c16To8_0_nByte_r         = 0;
  parameter c16To8_0_nByte_s         = 0;

  // Parameters

  // Iregs

  // Single ported memories

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam c16To8_0.x_w             = c16To8_0_x_w;
  defparam c16To8_0.y_w             = c16To8_0_y_w;
  defparam c16To8_0.run1_w          = c16To8_0_run1_w;
  defparam c16To8_0.run1_r          = c16To8_0_run1_r;
  defparam c16To8_0.run1_s          = c16To8_0_run1_s;
  defparam c16To8_0.nByte_w         = c16To8_0_nByte_w;
  defparam c16To8_0.nByte_r         = c16To8_0_nByte_r;
  defparam c16To8_0.nByte_s         = c16To8_0_nByte_s;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module
  parameter R_c16To8_0_run1                                              = 0;
  defparam  c16To8_0.R_run1                                              = R_c16To8_0_run1;
  parameter R_c16To8_0_nByte                                             = 1;
  defparam  c16To8_0.R_nByte                                             = R_c16To8_0_nByte;

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire                  [c16To8_0_y_w-1:0]  c16To8_0_y;
  wire                                      c16To8_0_y_or;
  wire                                      c16To8_0_y_ff;
  wire                                      c16To8_0_y_we;

  wire                  [c16To8_0_x_w-1:0]  c16To8_0_x;
  wire                                      c16To8_0_x_ir;
  wire                                      c16To8_0_x_fe;
  wire                                      c16To8_0_x_re;

  wire                                      c16To8_0_regWe;
  wire                                      c16To8_0_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  c16To8 c16To8_0(c16To8_0_y, c16To8_0_y_or, c16To8_0_y_ff, c16To8_0_y_we,
                  c16To8_0_x, c16To8_0_x_ir, c16To8_0_x_fe, c16To8_0_x_re, 
                  regBus, regWe, regRe, c16To8_0_regWe, c16To8_0_regRe, clk, clk2, reset);


//==============================================================================
