//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter agcMain_0_x_w             = 24;

  // Outputs
  parameter agcMain_0_attn_w          = 16;
  parameter agcMain_0_attnDb_w        = 7;

  // Input control lines
  parameter agcMain_0_ssDetect_w      = 1;

  // Output control lines
  parameter agcMain_0_ssAcqHalt_w     = 1;

  // Eregs
  parameter agcMain_0_run1_w          = 2;
  parameter agcMain_0_run1_r          = 0;
  parameter agcMain_0_run1_s          = 0;
  parameter agcMain_0_numSteps_w      = 3;
  parameter agcMain_0_numSteps_r      = 0;
  parameter agcMain_0_numSteps_s      = 0;
  parameter agcMain_0_attnCur_w       = 7;
  parameter agcMain_0_attnCur_r       = 0;
  parameter agcMain_0_attnCur_s       = 0;
  parameter agcMain_0_attnCurReal_w   = 7;
  parameter agcMain_0_attnCurReal_r   = 0;
  parameter agcMain_0_attnCurReal_s   = 0;
  parameter agcMain_0_attnInit_w      = 7;
  parameter agcMain_0_attnInit_r      = 0;
  parameter agcMain_0_attnInit_s      = 0;
  parameter agcMain_0_attnTest_w      = 7;
  parameter agcMain_0_attnTest_r      = 0;
  parameter agcMain_0_attnTest_s      = 0;
  parameter agcMain_0_backOffTgt_w    = 6;
  parameter agcMain_0_backOffTgt_r    = 13;
  parameter agcMain_0_backOffTgt_s    = 0;
  parameter agcMain_0_attnInitUpdt_w  = 1;
  parameter agcMain_0_attnInitUpdt_r  = 0;
  parameter agcMain_0_attnInitUpdt_s  = 0;
  parameter agcMain_0_thrLo_w         = 6;
  parameter agcMain_0_thrLo_r         = 22;
  parameter agcMain_0_thrLo_s         = 0;
  parameter agcMain_0_thrHi_w         = 6;
  parameter agcMain_0_thrHi_r         = 13;
  parameter agcMain_0_thrHi_s         = 0;
  parameter agcMain_0_thrX_w          = 6;
  parameter agcMain_0_thrX_r          = 5;
  parameter agcMain_0_thrX_s          = 0;
  parameter agcMain_0_stepDb_w        = 6;
  parameter agcMain_0_stepDb_r        = 25;
  parameter agcMain_0_stepDb_s        = 0;
  parameter agcMain_0_waitSettle_w    = 9;
  parameter agcMain_0_waitSettle_r    = 48;
  parameter agcMain_0_waitSettle_s    = 0;
  parameter agcMain_0_waitFinal_w     = 10;
  parameter agcMain_0_waitFinal_r     = 320;
  parameter agcMain_0_waitFinal_s     = 0;

  // Parameters
  parameter agcMain_0_wx              = 12;
  parameter agcMain_0_ws              = 16;
  parameter agcMain_0_waitTimeOut     = 250;
  parameter agcMain_0_attnMax         = 69;
  parameter agcMain_0_numSmplRssi     = 63;
  parameter agcMain_0_StReset         = 0;
  parameter agcMain_0_StSearch        = 1;
  parameter agcMain_0_StStep          = 2;
  parameter agcMain_0_StFine          = 3;
  parameter agcMain_0_StTestAttn      = 4;
  parameter agcMain_0_StWait          = 5;
  parameter agcMain_0_StDone          = 6;
  parameter agcMain_0_StWaitSettle0   = 7;
  parameter agcMain_0_StWaitSettle1   = 8;
  parameter agcMain_0_StWaitSettle2   = 9;
  parameter agcMain_0_StWaitSettle3   = 10;

  // Iregs

  // Single ported memories

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam agcMain_0.x_w             = agcMain_0_x_w;
  defparam agcMain_0.attn_w          = agcMain_0_attn_w;
  defparam agcMain_0.attnDb_w        = agcMain_0_attnDb_w;
  defparam agcMain_0.ssDetect_w      = agcMain_0_ssDetect_w;
  defparam agcMain_0.ssAcqHalt_w     = agcMain_0_ssAcqHalt_w;
  defparam agcMain_0.run1_w          = agcMain_0_run1_w;
  defparam agcMain_0.run1_r          = agcMain_0_run1_r;
  defparam agcMain_0.run1_s          = agcMain_0_run1_s;
  defparam agcMain_0.numSteps_w      = agcMain_0_numSteps_w;
  defparam agcMain_0.numSteps_r      = agcMain_0_numSteps_r;
  defparam agcMain_0.numSteps_s      = agcMain_0_numSteps_s;
  defparam agcMain_0.attnCur_w       = agcMain_0_attnCur_w;
  defparam agcMain_0.attnCur_r       = agcMain_0_attnCur_r;
  defparam agcMain_0.attnCur_s       = agcMain_0_attnCur_s;
  defparam agcMain_0.attnCurReal_w   = agcMain_0_attnCurReal_w;
  defparam agcMain_0.attnCurReal_r   = agcMain_0_attnCurReal_r;
  defparam agcMain_0.attnCurReal_s   = agcMain_0_attnCurReal_s;
  defparam agcMain_0.attnInit_w      = agcMain_0_attnInit_w;
  defparam agcMain_0.attnInit_r      = agcMain_0_attnInit_r;
  defparam agcMain_0.attnInit_s      = agcMain_0_attnInit_s;
  defparam agcMain_0.attnTest_w      = agcMain_0_attnTest_w;
  defparam agcMain_0.attnTest_r      = agcMain_0_attnTest_r;
  defparam agcMain_0.attnTest_s      = agcMain_0_attnTest_s;
  defparam agcMain_0.backOffTgt_w    = agcMain_0_backOffTgt_w;
  defparam agcMain_0.backOffTgt_r    = agcMain_0_backOffTgt_r;
  defparam agcMain_0.backOffTgt_s    = agcMain_0_backOffTgt_s;
  defparam agcMain_0.attnInitUpdt_w  = agcMain_0_attnInitUpdt_w;
  defparam agcMain_0.attnInitUpdt_r  = agcMain_0_attnInitUpdt_r;
  defparam agcMain_0.attnInitUpdt_s  = agcMain_0_attnInitUpdt_s;
  defparam agcMain_0.thrLo_w         = agcMain_0_thrLo_w;
  defparam agcMain_0.thrLo_r         = agcMain_0_thrLo_r;
  defparam agcMain_0.thrLo_s         = agcMain_0_thrLo_s;
  defparam agcMain_0.thrHi_w         = agcMain_0_thrHi_w;
  defparam agcMain_0.thrHi_r         = agcMain_0_thrHi_r;
  defparam agcMain_0.thrHi_s         = agcMain_0_thrHi_s;
  defparam agcMain_0.thrX_w          = agcMain_0_thrX_w;
  defparam agcMain_0.thrX_r          = agcMain_0_thrX_r;
  defparam agcMain_0.thrX_s          = agcMain_0_thrX_s;
  defparam agcMain_0.stepDb_w        = agcMain_0_stepDb_w;
  defparam agcMain_0.stepDb_r        = agcMain_0_stepDb_r;
  defparam agcMain_0.stepDb_s        = agcMain_0_stepDb_s;
  defparam agcMain_0.waitSettle_w    = agcMain_0_waitSettle_w;
  defparam agcMain_0.waitSettle_r    = agcMain_0_waitSettle_r;
  defparam agcMain_0.waitSettle_s    = agcMain_0_waitSettle_s;
  defparam agcMain_0.waitFinal_w     = agcMain_0_waitFinal_w;
  defparam agcMain_0.waitFinal_r     = agcMain_0_waitFinal_r;
  defparam agcMain_0.waitFinal_s     = agcMain_0_waitFinal_s;
  defparam agcMain_0.wx              = agcMain_0_wx;
  defparam agcMain_0.ws              = agcMain_0_ws;
  defparam agcMain_0.waitTimeOut     = agcMain_0_waitTimeOut;
  defparam agcMain_0.attnMax         = agcMain_0_attnMax;
  defparam agcMain_0.numSmplRssi     = agcMain_0_numSmplRssi;
  defparam agcMain_0.StReset         = agcMain_0_StReset;
  defparam agcMain_0.StSearch        = agcMain_0_StSearch;
  defparam agcMain_0.StStep          = agcMain_0_StStep;
  defparam agcMain_0.StFine          = agcMain_0_StFine;
  defparam agcMain_0.StTestAttn      = agcMain_0_StTestAttn;
  defparam agcMain_0.StWait          = agcMain_0_StWait;
  defparam agcMain_0.StDone          = agcMain_0_StDone;
  defparam agcMain_0.StWaitSettle0   = agcMain_0_StWaitSettle0;
  defparam agcMain_0.StWaitSettle1   = agcMain_0_StWaitSettle1;
  defparam agcMain_0.StWaitSettle2   = agcMain_0_StWaitSettle2;
  defparam agcMain_0.StWaitSettle3   = agcMain_0_StWaitSettle3;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module
  parameter R_agcMain_0_run1                                             = 0;
  defparam  agcMain_0.R_run1                                             = R_agcMain_0_run1;
  parameter R_agcMain_0_numSteps                                         = 1;
  defparam  agcMain_0.R_numSteps                                         = R_agcMain_0_numSteps;
  parameter R_agcMain_0_attnCur                                          = 2;
  defparam  agcMain_0.R_attnCur                                          = R_agcMain_0_attnCur;
  parameter R_agcMain_0_attnCurReal                                      = 3;
  defparam  agcMain_0.R_attnCurReal                                      = R_agcMain_0_attnCurReal;
  parameter R_agcMain_0_attnInit                                         = 4;
  defparam  agcMain_0.R_attnInit                                         = R_agcMain_0_attnInit;
  parameter R_agcMain_0_attnTest                                         = 5;
  defparam  agcMain_0.R_attnTest                                         = R_agcMain_0_attnTest;
  parameter R_agcMain_0_backOffTgt                                       = 6;
  defparam  agcMain_0.R_backOffTgt                                       = R_agcMain_0_backOffTgt;
  parameter R_agcMain_0_attnInitUpdt                                     = 7;
  defparam  agcMain_0.R_attnInitUpdt                                     = R_agcMain_0_attnInitUpdt;
  parameter R_agcMain_0_thrLo                                            = 8;
  defparam  agcMain_0.R_thrLo                                            = R_agcMain_0_thrLo;
  parameter R_agcMain_0_thrHi                                            = 9;
  defparam  agcMain_0.R_thrHi                                            = R_agcMain_0_thrHi;
  parameter R_agcMain_0_thrX                                             = 10;
  defparam  agcMain_0.R_thrX                                             = R_agcMain_0_thrX;
  parameter R_agcMain_0_stepDb                                           = 11;
  defparam  agcMain_0.R_stepDb                                           = R_agcMain_0_stepDb;
  parameter R_agcMain_0_waitSettle                                       = 12;
  defparam  agcMain_0.R_waitSettle                                       = R_agcMain_0_waitSettle;
  parameter R_agcMain_0_waitFinal                                        = 13;
  defparam  agcMain_0.R_waitFinal                                        = R_agcMain_0_waitFinal;
  parameter R_agcMain_0_lut_agc_wrAdr                                    = 14;
  defparam  agcMain_0.R_lut_agc_wrAdr                                    = R_agcMain_0_lut_agc_wrAdr;
  parameter R_agcMain_0_lut_agc_wrDatHi                                  = 15;
  defparam  agcMain_0.R_lut_agc_wrDatHi                                  = R_agcMain_0_lut_agc_wrDatHi;
  parameter R_agcMain_0_lut_agc_wrDatLo                                  = 16;
  defparam  agcMain_0.R_lut_agc_wrDatLo                                  = R_agcMain_0_lut_agc_wrDatLo;
  parameter R_agcMain_0_lut_agc_simInit                                  = 17;
  defparam  agcMain_0.R_lut_agc_simInit                                  = R_agcMain_0_lut_agc_simInit;
  parameter R_agcMain_0_agcRssi_0_singleAdc                              = 18;
  defparam  agcMain_0.R_agcRssi_0_singleAdc                              = R_agcMain_0_agcRssi_0_singleAdc;

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire              [agcMain_0_attn_w-1:0]  agcMain_0_attn;
  wire                                      agcMain_0_attn_or;
  wire                                      agcMain_0_attn_ff;
  wire                                      agcMain_0_attn_we;

  wire            [agcMain_0_attnDb_w-1:0]  agcMain_0_attnDb;
  wire                                      agcMain_0_attnDb_or;
  wire                                      agcMain_0_attnDb_ff;
  wire                                      agcMain_0_attnDb_we;

  wire                 [agcMain_0_x_w-1:0]  agcMain_0_x;
  wire                                      agcMain_0_x_ir;
  wire                                      agcMain_0_x_fe;
  wire                                      agcMain_0_x_re;

  wire         [agcMain_0_ssAcqHalt_w-1:0]  agcMain_0_ssAcqHalt;

  wire          [agcMain_0_ssDetect_w-1:0]  agcMain_0_ssDetect;

  wire                                      agcMain_0_regWe;
  wire                                      agcMain_0_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  agcMain agcMain_0(agcMain_0_attn, agcMain_0_attn_or, agcMain_0_attn_ff, agcMain_0_attn_we,
                    agcMain_0_attnDb, agcMain_0_attnDb_or, agcMain_0_attnDb_ff, agcMain_0_attnDb_we,
                    agcMain_0_x, agcMain_0_x_ir, agcMain_0_x_fe, agcMain_0_x_re, 
                    agcMain_0_ssAcqHalt, 
                    agcMain_0_ssDetect, 
                    regBus, regWe, regRe, agcMain_0_regWe, agcMain_0_regRe, clk, clk2, reset);


//==============================================================================
