//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs

  // Outputs

  // Input control lines
  parameter X16_11b_irqExt_w        = 1;

  // Output control lines

  // Eregs
  parameter X16_11b_cmd_w           = 16;
  parameter X16_11b_cmd_r           = 0;
  parameter X16_11b_cmd_s           = 0;
  parameter X16_11b_pramAdr_w       = 0;
  parameter X16_11b_pramAdr_r       = 0;
  parameter X16_11b_pramAdr_s       = 0;
  parameter X16_11b_pramDat_w       = 0;
  parameter X16_11b_pramDat_r       = 0;
  parameter X16_11b_pramDat_s       = 0;
  parameter X16_11b_dramAdr_w       = 0;
  parameter X16_11b_dramAdr_r       = 0;
  parameter X16_11b_dramAdr_s       = 0;
  parameter X16_11b_dramDat_w       = 0;
  parameter X16_11b_dramDat_r       = 0;
  parameter X16_11b_dramDat_s       = 0;

  // Parameters
  parameter X16_11b_RegStart        = 0;
  parameter X16_11b_RegLen          = 512;
  parameter X16_11b_RegEnd          = 511;
  parameter X16_11b_DramStart       = 512;
  parameter X16_11b_DramLen         = 512;
  parameter X16_11b_DramEnd         = 1023;
  parameter X16_11b_DramAdrWidth    = 9;
  parameter X16_11b_PramStart       = 0;
  parameter X16_11b_PramLen         = 1024;
  parameter X16_11b_PramLen32       = 256;
  parameter X16_11b_PramEnd         = 1023;
  parameter X16_11b_PramAdrWidth    = 8;

  // Iregs

  // Single ported memories

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam X16_11b.irqExt_w        = X16_11b_irqExt_w;
  defparam X16_11b.cmd_w           = X16_11b_cmd_w;
  defparam X16_11b.cmd_r           = X16_11b_cmd_r;
  defparam X16_11b.cmd_s           = X16_11b_cmd_s;
  defparam X16_11b.pramAdr_w       = X16_11b_pramAdr_w;
  defparam X16_11b.pramAdr_r       = X16_11b_pramAdr_r;
  defparam X16_11b.pramAdr_s       = X16_11b_pramAdr_s;
  defparam X16_11b.pramDat_w       = X16_11b_pramDat_w;
  defparam X16_11b.pramDat_r       = X16_11b_pramDat_r;
  defparam X16_11b.pramDat_s       = X16_11b_pramDat_s;
  defparam X16_11b.dramAdr_w       = X16_11b_dramAdr_w;
  defparam X16_11b.dramAdr_r       = X16_11b_dramAdr_r;
  defparam X16_11b.dramAdr_s       = X16_11b_dramAdr_s;
  defparam X16_11b.dramDat_w       = X16_11b_dramDat_w;
  defparam X16_11b.dramDat_r       = X16_11b_dramDat_r;
  defparam X16_11b.dramDat_s       = X16_11b_dramDat_s;
  defparam X16_11b.RegStart        = X16_11b_RegStart;
  defparam X16_11b.RegLen          = X16_11b_RegLen;
  defparam X16_11b.RegEnd          = X16_11b_RegEnd;
  defparam X16_11b.DramStart       = X16_11b_DramStart;
  defparam X16_11b.DramLen         = X16_11b_DramLen;
  defparam X16_11b.DramEnd         = X16_11b_DramEnd;
  defparam X16_11b.DramAdrWidth    = X16_11b_DramAdrWidth;
  defparam X16_11b.PramStart       = X16_11b_PramStart;
  defparam X16_11b.PramLen         = X16_11b_PramLen;
  defparam X16_11b.PramLen32       = X16_11b_PramLen32;
  defparam X16_11b.PramEnd         = X16_11b_PramEnd;
  defparam X16_11b.PramAdrWidth    = X16_11b_PramAdrWidth;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module
  parameter R_X16_11b_cmd                                                = 0;
  defparam  X16_11b.R_cmd                                                = R_X16_11b_cmd;
  parameter R_X16_11b_pramAdr                                            = 1;
  defparam  X16_11b.R_pramAdr                                            = R_X16_11b_pramAdr;
  parameter R_X16_11b_pramDat                                            = 2;
  defparam  X16_11b.R_pramDat                                            = R_X16_11b_pramDat;
  parameter R_X16_11b_dramAdr                                            = 3;
  defparam  X16_11b.R_dramAdr                                            = R_X16_11b_dramAdr;
  parameter R_X16_11b_dramDat                                            = 4;
  defparam  X16_11b.R_dramDat                                            = R_X16_11b_dramDat;

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire              [X16_11b_irqExt_w-1:0]  X16_11b_irqExt;

  wire                                      X16_11b_regWe;
  wire                                      X16_11b_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  X16 X16_11b(X16_11b_irqExt, 
              regBus, regWe, regRe, X16_11b_regWe, X16_11b_regRe, clk, clk2, reset);


//==============================================================================
