//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs

  // Outputs

  // Input control lines
  parameter X16_11a_irqExt_w        = 1;

  // Output control lines

  // Eregs
  parameter X16_11a_cmd_w           = 16;
  parameter X16_11a_cmd_r           = 0;
  parameter X16_11a_cmd_s           = 0;
  parameter X16_11a_pramAdr_w       = 0;
  parameter X16_11a_pramAdr_r       = 0;
  parameter X16_11a_pramAdr_s       = 0;
  parameter X16_11a_pramDat_w       = 0;
  parameter X16_11a_pramDat_r       = 0;
  parameter X16_11a_pramDat_s       = 0;
  parameter X16_11a_dramAdr_w       = 0;
  parameter X16_11a_dramAdr_r       = 0;
  parameter X16_11a_dramAdr_s       = 0;
  parameter X16_11a_dramDat_w       = 0;
  parameter X16_11a_dramDat_r       = 0;
  parameter X16_11a_dramDat_s       = 0;

  // Parameters
  parameter X16_11a_RegStart        = 0;
  parameter X16_11a_RegLen          = 512;
  parameter X16_11a_RegEnd          = 511;
  parameter X16_11a_DramStart       = 512;
  parameter X16_11a_DramLen         = 512;
  parameter X16_11a_DramEnd         = 1023;
  parameter X16_11a_DramAdrWidth    = 9;
  parameter X16_11a_PramStart       = 0;
  parameter X16_11a_PramLen         = 2560;
  parameter X16_11a_PramLen32       = 640;
  parameter X16_11a_PramEnd         = 2559;
  parameter X16_11a_PramAdrWidth    = 10;

  // Iregs

  // Single ported memories

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam X16_11a.irqExt_w        = X16_11a_irqExt_w;
  defparam X16_11a.cmd_w           = X16_11a_cmd_w;
  defparam X16_11a.cmd_r           = X16_11a_cmd_r;
  defparam X16_11a.cmd_s           = X16_11a_cmd_s;
  defparam X16_11a.pramAdr_w       = X16_11a_pramAdr_w;
  defparam X16_11a.pramAdr_r       = X16_11a_pramAdr_r;
  defparam X16_11a.pramAdr_s       = X16_11a_pramAdr_s;
  defparam X16_11a.pramDat_w       = X16_11a_pramDat_w;
  defparam X16_11a.pramDat_r       = X16_11a_pramDat_r;
  defparam X16_11a.pramDat_s       = X16_11a_pramDat_s;
  defparam X16_11a.dramAdr_w       = X16_11a_dramAdr_w;
  defparam X16_11a.dramAdr_r       = X16_11a_dramAdr_r;
  defparam X16_11a.dramAdr_s       = X16_11a_dramAdr_s;
  defparam X16_11a.dramDat_w       = X16_11a_dramDat_w;
  defparam X16_11a.dramDat_r       = X16_11a_dramDat_r;
  defparam X16_11a.dramDat_s       = X16_11a_dramDat_s;
  defparam X16_11a.RegStart        = X16_11a_RegStart;
  defparam X16_11a.RegLen          = X16_11a_RegLen;
  defparam X16_11a.RegEnd          = X16_11a_RegEnd;
  defparam X16_11a.DramStart       = X16_11a_DramStart;
  defparam X16_11a.DramLen         = X16_11a_DramLen;
  defparam X16_11a.DramEnd         = X16_11a_DramEnd;
  defparam X16_11a.DramAdrWidth    = X16_11a_DramAdrWidth;
  defparam X16_11a.PramStart       = X16_11a_PramStart;
  defparam X16_11a.PramLen         = X16_11a_PramLen;
  defparam X16_11a.PramLen32       = X16_11a_PramLen32;
  defparam X16_11a.PramEnd         = X16_11a_PramEnd;
  defparam X16_11a.PramAdrWidth    = X16_11a_PramAdrWidth;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module
  parameter R_X16_11a_cmd                                                = 0;
  defparam  X16_11a.R_cmd                                                = R_X16_11a_cmd;
  parameter R_X16_11a_pramAdr                                            = 1;
  defparam  X16_11a.R_pramAdr                                            = R_X16_11a_pramAdr;
  parameter R_X16_11a_pramDat                                            = 2;
  defparam  X16_11a.R_pramDat                                            = R_X16_11a_pramDat;
  parameter R_X16_11a_dramAdr                                            = 3;
  defparam  X16_11a.R_dramAdr                                            = R_X16_11a_dramAdr;
  parameter R_X16_11a_dramDat                                            = 4;
  defparam  X16_11a.R_dramDat                                            = R_X16_11a_dramDat;

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire              [X16_11a_irqExt_w-1:0]  X16_11a_irqExt;

  wire                                      X16_11a_regWe;
  wire                                      X16_11a_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  X16 X16_11a(X16_11a_irqExt, 
              regBus, regWe, regRe, X16_11a_regWe, X16_11a_regRe, clk, clk2, reset);


//==============================================================================
