//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs

  // Outputs

  // Input control lines
  parameter X16_0_irqExt_w        = 1;

  // Output control lines

  // Eregs
  parameter X16_0_cmd_w           = 16;
  parameter X16_0_cmd_r           = 0;
  parameter X16_0_cmd_s           = 0;
  parameter X16_0_pramAdr_w       = 0;
  parameter X16_0_pramAdr_r       = 0;
  parameter X16_0_pramAdr_s       = 0;
  parameter X16_0_pramDat_w       = 0;
  parameter X16_0_pramDat_r       = 0;
  parameter X16_0_pramDat_s       = 0;
  parameter X16_0_dramAdr_w       = 0;
  parameter X16_0_dramAdr_r       = 0;
  parameter X16_0_dramAdr_s       = 0;
  parameter X16_0_dramDat_w       = 0;
  parameter X16_0_dramDat_r       = 0;
  parameter X16_0_dramDat_s       = 0;

  // Parameters
  parameter X16_0_RegStart        = 0;
  parameter X16_0_RegLen          = 512;
  parameter X16_0_RegEnd          = 511;
  parameter X16_0_DramStart       = 512;
  parameter X16_0_DramLen         = 512;
  parameter X16_0_DramEnd         = 1023;
  parameter X16_0_DramAdrWidth    = 9;
  parameter X16_0_PramStart       = 0;
  parameter X16_0_PramLen         = 4096;
  parameter X16_0_PramLen32       = 1024;
  parameter X16_0_PramEnd         = 4095;
  parameter X16_0_PramAdrWidth    = 10;

  // Iregs

  // Single ported memories

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam X16_0.irqExt_w        = X16_0_irqExt_w;
  defparam X16_0.cmd_w           = X16_0_cmd_w;
  defparam X16_0.cmd_r           = X16_0_cmd_r;
  defparam X16_0.cmd_s           = X16_0_cmd_s;
  defparam X16_0.pramAdr_w       = X16_0_pramAdr_w;
  defparam X16_0.pramAdr_r       = X16_0_pramAdr_r;
  defparam X16_0.pramAdr_s       = X16_0_pramAdr_s;
  defparam X16_0.pramDat_w       = X16_0_pramDat_w;
  defparam X16_0.pramDat_r       = X16_0_pramDat_r;
  defparam X16_0.pramDat_s       = X16_0_pramDat_s;
  defparam X16_0.dramAdr_w       = X16_0_dramAdr_w;
  defparam X16_0.dramAdr_r       = X16_0_dramAdr_r;
  defparam X16_0.dramAdr_s       = X16_0_dramAdr_s;
  defparam X16_0.dramDat_w       = X16_0_dramDat_w;
  defparam X16_0.dramDat_r       = X16_0_dramDat_r;
  defparam X16_0.dramDat_s       = X16_0_dramDat_s;
  defparam X16_0.RegStart        = X16_0_RegStart;
  defparam X16_0.RegLen          = X16_0_RegLen;
  defparam X16_0.RegEnd          = X16_0_RegEnd;
  defparam X16_0.DramStart       = X16_0_DramStart;
  defparam X16_0.DramLen         = X16_0_DramLen;
  defparam X16_0.DramEnd         = X16_0_DramEnd;
  defparam X16_0.DramAdrWidth    = X16_0_DramAdrWidth;
  defparam X16_0.PramStart       = X16_0_PramStart;
  defparam X16_0.PramLen         = X16_0_PramLen;
  defparam X16_0.PramLen32       = X16_0_PramLen32;
  defparam X16_0.PramEnd         = X16_0_PramEnd;
  defparam X16_0.PramAdrWidth    = X16_0_PramAdrWidth;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module
  parameter R_X16_0_cmd                                                  = 0;
  defparam  X16_0.R_cmd                                                  = R_X16_0_cmd;
  parameter R_X16_0_pramAdr                                              = 1;
  defparam  X16_0.R_pramAdr                                              = R_X16_0_pramAdr;
  parameter R_X16_0_pramDat                                              = 2;
  defparam  X16_0.R_pramDat                                              = R_X16_0_pramDat;
  parameter R_X16_0_dramAdr                                              = 3;
  defparam  X16_0.R_dramAdr                                              = R_X16_0_dramAdr;
  parameter R_X16_0_dramDat                                              = 4;
  defparam  X16_0.R_dramDat                                              = R_X16_0_dramDat;

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire                [X16_0_irqExt_w-1:0]  X16_0_irqExt;

  wire                                      X16_0_regWe;
  wire                                      X16_0_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  X16 X16_0(X16_0_irqExt, 
            regBus, regWe, regRe, X16_0_regWe, X16_0_regRe, clk, clk2, reset);


//==============================================================================
