//====================================================================================
//  Copyright (C) BAY9, 2016
//====================================================================================
//
// MODULE:
//   deScr8
//
// ----------------------------------------------------------------------------------------
// ----------------------------------------------------------------------------------------

module deScr8(y, y_or, y_ff, y_we, 
              x, x_ir, x_fe, x_re, 
              run1, 
              regBus, regWe, regRe, regWeOut, regReOut, clk1, clk2, reset);

  // --------------------------------------------------------------------------------------
  // Module parameters
  parameter y_w               = 0;
  parameter x_w               = 0;

  parameter run1_w            = 0;

  parameter w                 = 0;
  parameter StInit            = 0;
  parameter StSkip            = 0;
  parameter StDescr           = 0;
  parameter StDescrOut        = 0;
  parameter p0                = 0;
  parameter p1                = 0;
  parameter p2                = 0;
  parameter p3                = 0;
  parameter p4                = 0;
  parameter p5                = 0;
  parameter p6                = 0;
  parameter p7                = 0;

  parameter s_w               = 0;
  parameter s_n               = 0;
  parameter s_m               = 0;
  parameter st_w              = 0;
  parameter st_n              = 0;
  parameter st_m              = 0;

  // --------------------------------------------------------------------------------------
  // Inputs and outputs
  output            [y_w-1:0]  y;
  output                       y_or;
  input                        y_ff;
  output                       y_we;
  assign                       y_we = y_or & ~y_ff;

  input             [x_w-1:0]  x;
  output                       x_ir;
  input                        x_fe;
  output                       x_re;
  assign                       x_re = x_ir & ~x_fe;

  input          [run1_w-1:0]  run1;

  // Define clock and reset
  input                        clk1;
  input                        clk2;
  input                        reset;

  // Inputs and outputs for registers
  inout                [15:0]  regBus;
  input                        regWe;
  input                        regRe;
  output                       regWeOut;
  output                       regReOut;

  // Assign clock
  wire clk;
  assign clk = clk1;

  // --------------------------------------------------------------------------------------
  // External status registers
  // --------------------------------------------------------------------------------------
  // Internal status registers
  reg               [s_w-1:0]  s;
  reg              [st_w-1:0]  st;

  // --------------------------------------------------------------------------------------
  // Define register control output
  assign regWeOut = 0;
  assign regReOut = 0;

// ----------------------------------------------------------------------------------------
//=========================================================================================

  // --------------------------------------------------------------------------------------
  // Register definitions
  reg              x_reD;
  reg     [w-1:0]  yR;
  wire    [w-1:0]  sn;
  
  // --------------------------------------------------------------------------------------
  // Assign input and output enable
  assign x_ir = run1==1;
  
  // --------------------------------------------------------------------------------------
  // Feedback for internal state and descrambling
  assign sn[0] = ^(p0 & s);
  assign sn[1] = ^(p1 & s);
  assign sn[2] = ^(p2 & s);
  assign sn[3] = ^(p3 & s);
  assign sn[4] = ^(p4 & s);
  assign sn[5] = ^(p5 & s);
  assign sn[6] = ^(p6 & s);
  assign sn[7] = ^(p7 & s);

  // --------------------------------------------------------------------------------------
  // FSM
  always @(posedge clk) begin
    
    // Reset
    if (run1==0) begin
      s     <= 0;
      st    <= StInit;
      x_reD <= 0;
      
    // Normal operation
    end else begin
      
      // Delayed read enable
      x_reD <= x_re;

      // Process upon read enable
      if (x_re) begin
        if (st==StInit) begin
          s  <= {x[1], x[2], x[3], x[4], x[5], x[6], x[0]^x[3]};
          st <= StSkip;
        end else
        
        if (st==StSkip) begin
          s  <= sn[6:0];
          st <= StDescr;
        end else
        
        if (st==StDescr | st==StDescrOut) begin
          yR <= x ^ {sn[0], sn[1], sn[2], sn[3], sn[4], sn[5], sn[6], sn[7]};
          s  <= sn[6:0];
          st <= StDescrOut;
        end
      end

    end // if (run1==0) ... else
  end // always
  
  // Assign output y
  assign y_or = x_reD & (st==StDescrOut);
  assign y    = yR;

endmodule
//=========================================================================================

