//====================================================================================
//  Copyright (C) BAY9, 2016
//====================================================================================
//
// MODULE:
//   dePunct
//
// ----------------------------------------------------------------------------------------
// ----------------------------------------------------------------------------------------

module dePunct(y, y_or, y_ff, y_we, 
               x, x_ir, x_fe, x_re, 
               regBus, regWe, regRe, regWeOut, regReOut, clk1, clk2, reset);

  // --------------------------------------------------------------------------------------
  // Module parameters
  parameter y_w               = 0;
  parameter x_w               = 0;


  parameter run1_w            = 0;
  parameter run1_r            = 0;
  parameter run1_s            = 0;
  parameter R_run1            = 0;

  parameter w                 = 0;

  // --------------------------------------------------------------------------------------
  // Inputs and outputs
  output            [y_w-1:0]  y;
  output                       y_or;
  input                        y_ff;
  output                       y_we;
  assign                       y_we = y_or & ~y_ff;

  input             [x_w-1:0]  x;
  output                       x_ir;
  input                        x_fe;
  output                       x_re;
  assign                       x_re = x_ir & ~x_fe;


  // Define clock and reset
  input                        clk1;
  input                        clk2;
  input                        reset;

  // Inputs and outputs for registers
  inout                [15:0]  regBus;
  input                        regWe;
  input                        regRe;
  output                       regWeOut;
  output                       regReOut;

  // Wires for external registers
  wire           [run1_w-1:0]  run1_q;
  wire           [run1_w-1:0]  run1_d;
  wire                         run1_weint;
  assign                       run1_weint = 0;

  // Assign clock
  wire clk;
  assign clk = clk1;

  // --------------------------------------------------------------------------------------
  // External status registers
  ereg run1(run1_q, regBus, run1_d, run1_weint, regWe, regRe, clk, reset);
  defparam run1.w    = run1_w;
  defparam run1.rval = run1_r;
  defparam run1.sgn  = run1_s;
  defparam run1.adr  = R_run1;

  // --------------------------------------------------------------------------------------
  // Define register control output
  assign regWeOut = 0;
  assign regReOut = 0;

// ----------------------------------------------------------------------------------------
//=========================================================================================

  // --------------------------------------------------------------------------------------
  // Register definitions
  wire    [w-1:0]  x0, x1;    // Split input
  reg     [w-1:0]  x1D;       // Delayed input
  reg     [w-1:0]  y0, y1;    // Partial outputs
  reg       [1:0]  cnt;       // Input sample counter
  wire      [1:0]  cntMax;    // Count to count max
  
  // --------------------------------------------------------------------------------------
  // Assign input enable
  assign x_ir = ~y_ff & 
                ( run1_q==1           | 
                 (run1_q==2 & cnt!=3) | 
                 (run1_q==3 & cnt!=2)
                );
  
  // --------------------------------------------------------------------------------------
  // Split input
  assign x0 = x[  w-1:0];
  assign x1 = x[2*w-1:w];

  // Count outputs until 1, 3, 2
  assign cntMax = run1_q ^ (run1_q>>1);

  // --------------------------------------------------------------------------------------
  // FSM
  always @(posedge clk) begin
    
    // Reset
    if (run1_q==0) begin
      cnt <= 0;
      
    // Normal operation
    end else begin
      
      // Update counter depending on mode 
      if (y_we) begin
        if (cnt==cntMax) begin
          cnt <= 0;
        end else begin
          cnt <= cnt+1;
        end
        x1D <= x1;
      end

    end // if (run1_q==0) ... else
  end // always

  // --------------------------------------------------------------------------------------
  // Define output depending on mode and counter
  always @(*) begin
    
    // run1==1 -> R = 1/2
    if (run1_q==1) begin
      y0 = x0;
      y1 = x1;
    end else
    
    // run1==2 -> R = 2/3
    if (run1_q==2) begin

      if (cnt==0) begin
        y0 = x0;
        y1 = x1;
      end else
      
      if (cnt==1) begin
        y0 = x0;
        y1 = 0; 
      end else
      
      if (cnt==2) begin
        y0 = x1D;
        y1 = x0; 
      end else
      
      begin
        y0 = x1D;
        y1 = 0;
      end

    end else

    // run1==3 -> R = 3/4
    if (run1_q==3) begin

      if (cnt==0) begin
        y0 = x0;
        y1 = x1;
      end else 

      if (cnt==1) begin
        y0 = x0;
        y1 = 0; 
      end else
      
      begin
        y0 = 0;
        y1 = x1D;
      end

    end else
    
    // run1==0 -> Off -> just set something
    begin
      y0 = 0;
      y1 = 0;
    end

  end // always @(*) ...
  
  // --------------------------------------------------------------------------------------
  // Assign and enable output
  assign y    = {y1, y0};
  assign y_or = x_re                 | 
                (run1_q==2 & cnt==3) |
                (run1_q==3 & cnt==2);

endmodule
//=========================================================================================

