//====================================================================================
//  Copyright (C) BAY9, 2016
//====================================================================================
//
// MODULE:
//   dcOffCorr
//
// ----------------------------------------------------------------------------------------
// ----------------------------------------------------------------------------------------

module dcOffCorr(yTx, yTx_or, yTx_ff, yTx_we, 
                 yRx, yRx_or, yRx_ff, yRx_we, 
                 xTx, xTx_ir, xTx_fe, xTx_re, 
                 xRx, xRx_ir, xRx_fe, xRx_re, 
                 attnDb, attnDb_ir, attnDb_fe, attnDb_re, 
                 run1, 
                 regBus, regWe, regRe, regWeOut, regReOut, clk1, clk2, reset);

  // --------------------------------------------------------------------------------------
  // Module parameters
  parameter yTx_w             = 0;
  parameter yRx_w             = 0;
  parameter xTx_w             = 0;
  parameter xRx_w             = 0;
  parameter attnDb_w          = 0;

  parameter run1_w            = 0;

  parameter corrOn_w          = 0;
  parameter corrOn_r          = 0;
  parameter corrOn_s          = 0;
  parameter R_corrOn          = 0;
  parameter txDcOffRe_w       = 0;
  parameter txDcOffRe_r       = 0;
  parameter txDcOffRe_s       = 0;
  parameter R_txDcOffRe       = 0;
  parameter txDcOffIm_w       = 0;
  parameter txDcOffIm_r       = 0;
  parameter txDcOffIm_s       = 0;
  parameter R_txDcOffIm       = 0;

  parameter w                 = 0;

  parameter yRe_w             = 0;
  parameter yRe_n             = 0;
  parameter yRe_m             = 0;
  parameter yIm_w             = 0;
  parameter yIm_n             = 0;
  parameter yIm_m             = 0;

  // --------------------------------------------------------------------------------------
  // Inputs and outputs
  output          [yTx_w-1:0]  yTx;
  output                       yTx_or;
  input                        yTx_ff;
  output                       yTx_we;
  assign                       yTx_we = yTx_or & ~yTx_ff;

  output          [yRx_w-1:0]  yRx;
  output                       yRx_or;
  input                        yRx_ff;
  output                       yRx_we;
  assign                       yRx_we = yRx_or & ~yRx_ff;

  input           [xTx_w-1:0]  xTx;
  output                       xTx_ir;
  input                        xTx_fe;
  output                       xTx_re;
  assign                       xTx_re = xTx_ir & ~xTx_fe;

  input           [xRx_w-1:0]  xRx;
  output                       xRx_ir;
  input                        xRx_fe;
  output                       xRx_re;
  assign                       xRx_re = xRx_ir & ~xRx_fe;

  input        [attnDb_w-1:0]  attnDb;
  output                       attnDb_ir;
  input                        attnDb_fe;
  output                       attnDb_re;
  assign                       attnDb_re = attnDb_ir & ~attnDb_fe;

  input          [run1_w-1:0]  run1;

  // Define clock and reset
  input                        clk1;
  input                        clk2;
  input                        reset;

  // Inputs and outputs for registers
  inout                [15:0]  regBus;
  input                        regWe;
  input                        regRe;
  output                       regWeOut;
  output                       regReOut;

  // Wires for external registers
  wire         [corrOn_w-1:0]  corrOn_q;
  wire         [corrOn_w-1:0]  corrOn_d;
  wire                         corrOn_weint;
  assign                       corrOn_weint = 0;

  wire      [txDcOffRe_w-1:0]  txDcOffRe_q;
  wire      [txDcOffRe_w-1:0]  txDcOffRe_d;
  wire                         txDcOffRe_weint;
  assign                       txDcOffRe_weint = 0;

  wire      [txDcOffIm_w-1:0]  txDcOffIm_q;
  wire      [txDcOffIm_w-1:0]  txDcOffIm_d;
  wire                         txDcOffIm_weint;
  assign                       txDcOffIm_weint = 0;

  // Assign clock
  wire clk;
  assign clk = clk1;

  // --------------------------------------------------------------------------------------
  // External status registers
  ereg corrOn(corrOn_q, regBus, corrOn_d, corrOn_weint, regWe, regRe, clk, reset);
  defparam corrOn.w    = corrOn_w;
  defparam corrOn.rval = corrOn_r;
  defparam corrOn.sgn  = corrOn_s;
  defparam corrOn.adr  = R_corrOn;

  ereg txDcOffRe(txDcOffRe_q, regBus, txDcOffRe_d, txDcOffRe_weint, regWe, regRe, clk, reset);
  defparam txDcOffRe.w    = txDcOffRe_w;
  defparam txDcOffRe.rval = txDcOffRe_r;
  defparam txDcOffRe.sgn  = txDcOffRe_s;
  defparam txDcOffRe.adr  = R_txDcOffRe;

  ereg txDcOffIm(txDcOffIm_q, regBus, txDcOffIm_d, txDcOffIm_weint, regWe, regRe, clk, reset);
  defparam txDcOffIm.w    = txDcOffIm_w;
  defparam txDcOffIm.rval = txDcOffIm_r;
  defparam txDcOffIm.sgn  = txDcOffIm_s;
  defparam txDcOffIm.adr  = R_txDcOffIm;

  // --------------------------------------------------------------------------------------
  // Internal status registers
  reg             [yRe_w-1:0]  yRe;
  reg             [yIm_w-1:0]  yIm;

  // --------------------------------------------------------------------------------------
  // Included instances
  `include "lut_rxDcOff.v"

  // --------------------------------------------------------------------------------------
  // Define register control output
  assign regWeOut = 0 | lut_rxDcOff_regWe;
  assign regReOut = 0 | lut_rxDcOff_regRe;

// ----------------------------------------------------------------------------------------
//=========================================================================================

  // --------------------------------------------------------------------------------------
  // Register definitions
  wire     [w:0]  xRe, xIm;
  wire     [w:0]  dcOffRe, dcOffIm;
  wire     [w:0]  xAddRe, xAddIm;
  wire   [w-1:0]  xSatRe, xSatIm;
  reg      [6:0]  attnDbReg;
  
  // --------------------------------------------------------------------------------------
  // Capture input and read from LUT
  assign attnDb_ir = 1;
  always @(posedge clk) begin
    if (attnDb_re) begin
      attnDbReg <= attnDb;
    end
  end
  assign lut_rxDcOff_adr = attnDbReg;
  
  // --------------------------------------------------------------------------------------
  // Assign input enable
  assign xRx_ir = (run1==3);
  assign xTx_ir = yTx_we;

  // Input data sign extension
  assign xRe = (run1==2) ? {xTx[  w-1], xTx[  w-1:0]}
                         : {xRx[  w-1], xRx[  w-1:0]};
  assign xIm = (run1==2) ? {xTx[2*w-1], xTx[2*w-1:w]}
                         : {xRx[2*w-1], xRx[2*w-1:w]};
  
  // DC offset sign extension
  assign dcOffRe = (run1==2) ? {txDcOffRe_q[w-1], txDcOffRe_q}
                             : {lut_rxDcOff_dat[w-1], lut_rxDcOff_dat[w-1:0]};
  assign dcOffIm = (run1==2) ? {txDcOffIm_q[w-1], txDcOffIm_q}
                             : {lut_rxDcOff_dat[2*w-1], lut_rxDcOff_dat[2*w-1:w]};
  
  // Add DC offset (possibly)
  assign xAddRe = xRe + (corrOn_q==0 ? 0 : dcOffRe);
  assign xAddIm = xIm + (corrOn_q==0 ? 0 : dcOffIm);
  
  // Saturation
  sat satRe(xSatRe, xAddRe);
  defparam satRe.x_w = w+1;
  defparam satRe.y_w = w;
  
  sat satIm(xSatIm, xAddIm);
  defparam satIm.x_w = w+1;
  defparam satIm.y_w = w;
  
  // Register output
  always @(posedge clk) begin
    if (run1==0) begin
      yRe   <= 0;
      yIm   <= 0;
    end else begin
      if (xRx_re | yTx_we) begin
        yRe   <= xSatRe;
        yIm   <= xSatIm;
      end
    end 
  end // always
  
  // Output values
  assign yRx    = {yIm, yRe};
  assign yRx_or = xRx_re;

  assign yTx    = {yIm, yRe};
  assign yTx_or = (run1==2);


endmodule
//=========================================================================================

