//====================================================================================
//  Copyright (C) BAY9, 2016
//====================================================================================
//
// MODULE:
//   dataBuf
//
// ----------------------------------------------------------------------------------------
// ----------------------------------------------------------------------------------------

module dataBuf(y, y_or, y_ff, y_we, 
               x, x_ir, x_fe, x_re, 
               regBus, regWe, regRe, regWeOut, regReOut, clk1, clk2, reset);

  // --------------------------------------------------------------------------------------
  // Module parameters
  parameter y_w               = 0;
  parameter x_w               = 0;


  parameter run1_w            = 0;
  parameter run1_r            = 0;
  parameter run1_s            = 0;
  parameter R_run1            = 0;
  parameter datAdr_w          = 0;
  parameter datAdr_r          = 0;
  parameter datAdr_s          = 0;
  parameter R_datAdr          = 0;
  parameter datVal_w          = 0;
  parameter datVal_r          = 0;
  parameter datVal_s          = 0;
  parameter R_datVal          = 0;

  parameter w                 = 0;
  parameter m                 = 0;
  parameter ModeReset         = 0;
  parameter ModeWrReg         = 0;
  parameter ModeWrPort        = 0;
  parameter ModeRdReg         = 0;
  parameter ModeRdPort        = 0;
  parameter ModeRdPortMult    = 0;

  parameter buf0_w            = 0;
  parameter buf0_n            = 0;
  parameter buf0_m            = 0;

  // --------------------------------------------------------------------------------------
  // Inputs and outputs
  output            [y_w-1:0]  y;
  output                       y_or;
  input                        y_ff;
  output                       y_we;
  assign                       y_we = y_or & ~y_ff;

  input             [x_w-1:0]  x;
  output                       x_ir;
  input                        x_fe;
  output                       x_re;
  assign                       x_re = x_ir & ~x_fe;


  // Define clock and reset
  input                        clk1;
  input                        clk2;
  input                        reset;

  // Inputs and outputs for registers
  inout                [15:0]  regBus;
  input                        regWe;
  input                        regRe;
  output                       regWeOut;
  output                       regReOut;

  // Wires for external registers
  wire           [run1_w-1:0]  run1_q;
  wire           [run1_w-1:0]  run1_d;
  wire                         run1_weint;

  wire         [datAdr_w-1:0]  datAdr_q;
  wire         [datAdr_w-1:0]  datAdr_d;
  wire                         datAdr_weint;
  assign                       datAdr_weint = 0;

  wire         [datVal_w-1:0]  datVal_q;
  wire         [datVal_w-1:0]  datVal_d;
  wire                         datVal_weint;

  // Wires for internal memories
  wire           [buf0_w-1:0]  buf0_q;
  wire           [buf0_w-1:0]  buf0_d;
  wire           [buf0_m-1:0]  buf0_adr;
  wire                         buf0_we;

  // Assign clock
  wire clk;
  assign clk = clk1;

  // --------------------------------------------------------------------------------------
  // External status registers
  ereg run1(run1_q, regBus, run1_d, run1_weint, regWe, regRe, clk, reset);
  defparam run1.w    = run1_w;
  defparam run1.rval = run1_r;
  defparam run1.sgn  = run1_s;
  defparam run1.adr  = R_run1;

  ereg datAdr(datAdr_q, regBus, datAdr_d, datAdr_weint, regWe, regRe, clk, reset);
  defparam datAdr.w    = datAdr_w;
  defparam datAdr.rval = datAdr_r;
  defparam datAdr.sgn  = datAdr_s;
  defparam datAdr.adr  = R_datAdr;

  ereg datVal(datVal_q, regBus, datVal_d, datVal_weint, regWe, regRe, clk, reset);
  defparam datVal.w    = datVal_w;
  defparam datVal.rval = datVal_r;
  defparam datVal.sgn  = datVal_s;
  defparam datVal.adr  = R_datVal;

  // --------------------------------------------------------------------------------------
  // Internal single ported memories
  spRam1 buf0(buf0_q, buf0_d, buf0_adr, buf0_we, clk);
  defparam buf0.w    = buf0_w;
  defparam buf0.n    = buf0_n;
  defparam buf0.m    = buf0_m;

  // --------------------------------------------------------------------------------------
  // Define register control output
  assign regWeOut = 0;
  assign regReOut = 0;

// ----------------------------------------------------------------------------------------
//=========================================================================================

  // --------------------------------------------------------------------------------------
  // Register definitions
  reg  [m-1:0] cnt;
  wire [m-1:0] cnt_nxt;
  reg          datAdrWeD, datAdrWeD2, datAdrWeD3;
  
  // --------------------------------------------------------------------------------------
  // Assign input and output enable
  assign x_ir = run1_q==ModeWrPort;
  assign y_or = run1_q==ModeRdPort | run1_q==ModeRdPortMult;
  assign y    = buf0_q;

  // --------------------------------------------------------------------------------------
  // Memory connections
  assign buf0_d   = run1_q==ModeWrReg   ? datVal_q   : x;
  assign buf0_we  = run1_q==ModeWrReg   ? datAdrWeD2 : x_re;
  assign buf0_adr = run1_q==ModeWrReg   ? datAdr_q   :
                    run1_q==ModeWrPort  ? cnt        :
                    run1_q==ModeRdReg   ? datAdr_q   :
                    y_we==1             ? cnt_nxt    : cnt;

  // Ereg connections
  assign datVal_d     = buf0_q;
  assign datVal_weint = run1_q==ModeRdReg & datAdrWeD3;

  assign run1_d       = 0;
  assign run1_weint   = (run1_q==ModeWrPort & cnt==datAdr_q & x_re) |
                        (run1_q==ModeRdPort & cnt==datAdr_q & y_we);

  // Count up address cyclically
  assign cnt_nxt = cnt==datAdr_q ? 0 : cnt+1;

  // --------------------------------------------------------------------------------------
  // FSM
  always @(posedge clk) begin
    
    // Reset
    if (run1_q==0) begin
      cnt         <= 0;
      datAdrWeD   <= 0;
      datAdrWeD2  <= 0;
    
    end else begin

      if ( (run1_q==ModeWrPort & x_re) | 
           ((run1_q==ModeRdPort | run1_q==ModeRdPortMult) & y_we) ) begin
        cnt <= cnt_nxt;
      end 

      // Enable buffer write from registers
      datAdrWeD  <= R_datAdr==regBus & regWe;
      datAdrWeD2 <= datAdrWeD;
      datAdrWeD3 <= datAdrWeD2;

    end
  end // always

endmodule
//=========================================================================================

