//====================================================================================
//  Copyright (C) BAY9, 2016
//====================================================================================
//
// MODULE:
//   ctfeCordic
//
// ----------------------------------------------------------------------------------------
// ----------------------------------------------------------------------------------------

module ctfeCordic(yAbs, yAbs_or, yAbs_ff, yAbs_we, 
                  yPh, yPh_or, yPh_ff, yPh_we, 
                  x, x_ir, x_fe, x_re, 
                  run1, 
                  regBus, regWe, regRe, regWeOut, regReOut, clk1, clk2, reset);

  // --------------------------------------------------------------------------------------
  // Module parameters
  parameter yAbs_w            = 0;
  parameter yPh_w             = 0;
  parameter x_w               = 0;

  parameter run1_w            = 0;

  parameter thr_w             = 0;
  parameter thr_r             = 0;
  parameter thr_s             = 0;
  parameter R_thr             = 0;

  parameter wx                = 0;
  parameter w                 = 0;
  parameter numIt             = 0;
  parameter ph0               = 0;
  parameter ph1               = 0;
  parameter ph2               = 0;
  parameter ph3               = 0;
  parameter ph4               = 0;
  parameter ph5               = 0;
  parameter ph6               = 0;
  parameter ph7               = 0;

  // --------------------------------------------------------------------------------------
  // Inputs and outputs
  output         [yAbs_w-1:0]  yAbs;
  output                       yAbs_or;
  input                        yAbs_ff;
  output                       yAbs_we;
  assign                       yAbs_we = yAbs_or & ~yAbs_ff;

  output          [yPh_w-1:0]  yPh;
  output                       yPh_or;
  input                        yPh_ff;
  output                       yPh_we;
  assign                       yPh_we = yPh_or & ~yPh_ff;

  input             [x_w-1:0]  x;
  output                       x_ir;
  input                        x_fe;
  output                       x_re;
  assign                       x_re = x_ir & ~x_fe;

  input          [run1_w-1:0]  run1;

  // Define clock and reset
  input                        clk1;
  input                        clk2;
  input                        reset;

  // Inputs and outputs for registers
  inout                [15:0]  regBus;
  input                        regWe;
  input                        regRe;
  output                       regWeOut;
  output                       regReOut;

  // Wires for external registers
  wire            [thr_w-1:0]  thr_q;
  wire            [thr_w-1:0]  thr_d;
  wire                         thr_weint;
  assign                       thr_weint = 0;

  // Assign clock
  wire clk;
  assign clk = clk1;

  // --------------------------------------------------------------------------------------
  // External status registers
  ereg thr(thr_q, regBus, thr_d, thr_weint, regWe, regRe, clk, reset);
  defparam thr.w    = thr_w;
  defparam thr.rval = thr_r;
  defparam thr.sgn  = thr_s;
  defparam thr.adr  = R_thr;

  // --------------------------------------------------------------------------------------
  // Define register control output
  assign regWeOut = 0;
  assign regReOut = 0;

// ----------------------------------------------------------------------------------------
//=========================================================================================

  // --------------------------------------------------------------------------------------
  // Register definitions
  reg           [1:0]  cntIn;
  reg           [1:0]  cnt;
  reg           [3:0]  cntIt;
  reg signed  [w-1:0]  xRe, xReBuf, xIm, phi, xA, xB, xS, p, xP, xM, addIn0, addIn1, addOut; 

  // --------------------------------------------------------------------------------------
  // Assign input and output enable
  assign x_ir = run1 & cntIn==0 | cntIn==1;
  assign yAbs_or = cntIt==numIt+2;
  assign yPh_or  = cntIt==numIt+2;
  assign yAbs    = xReBuf;
  assign yPh     = phi;
  
  // --------------------------------------------------------------------------------------
  // Signal processing behaviour
  always @(*) begin
        
    // xRe/xIm exchange mux
    if (cnt==0) begin
      xA = xRe;
      xB = xIm;
    end else begin
      xA = xIm;
      xB = xRe;
    end
    
    // Shifter
    case (cntIt[2:0])
      0: xS = xB;
      1: xS = xB;
      2: xS = xB>>>1;
      3: xS = xB>>>2;
      4: xS = xB>>>3;
      5: xS = xB>>>4;
      6: xS = xB>>>5;
      7: xS = xB>>>6;
    endcase
    
    // Phase LUT
    case (cntIt[2:0])
      0: p = ph0;
      1: p = ph1;
      2: p = ph2;
      3: p = ph3;
      4: p = ph4;
      5: p = ph5;
      6: p = ph6;
      7: p = ph7;
    endcase
    
    if (cntIt==numIt+1) begin
      xP = {2'b00, thr_q};
    end else
    if (cnt==1) begin
      xP = p;
    end else begin
      xP = xS;
    end
    
    xM = -xP;
    
    // Adder input 0
    if (cntIt==0) begin
      addIn0 = 0;
    end else
    if (cnt==1) begin
      addIn0 = phi;
    end else begin
      addIn0 = xA;
    end

    // Adder input 1
    if ((cnt==2 ^ xIm[w-1]) | cntIt==numIt+1) begin
      addIn1 = xM;
    end else begin
      addIn1 = xP;
    end
    
    // Adder
    addOut = addIn0 + addIn1;
    
  end

  // --------------------------------------------------------------------------------------
  // FSM
  always @(posedge clk) begin
    
    // Reset
    if (run1==0) begin
      cnt   <= 0;
      cntIt <= 0;
      cntIn <= 0;
      
    // Normal operation
    end else begin
      
      // Counter updates
      if (x_re) begin               // The input counter counts up while data is
        cntIn <= cntIn+1;           // being read from the input, and is reset at
      end else                      // the end of the Cordic operation
      if (cntIt==numIt+2) begin
        cntIn <= 0;
      end
      
      if (cnt==2 | cntIt==numIt+2) begin
        cnt <= 0;
      end else                      // The inner iteration counter counts 0,1,2,0,...
      if (cntIn==2) begin           // when data is in the input, and continues until
        cnt <= cnt+1;               // the end of Cordic operation
      end
      
      if (cntIt==numIt+2) begin
        cntIt <= 0;
      end else
      if (cnt==2 | cntIt==numIt+1) begin
        cntIt <= cntIt+1;
      end
      
      // Register update using input - load xRe/xIm serially
      if (x_re) begin
        if (cntIn==0) begin
          xRe  <= x;
        end else begin
          xIm  <= x;
        end
      end else
      
      // Update registers - depends on internal states
      if (cnt==0) begin
        xReBuf <= addOut;
      end else 
      if (cnt==1) begin
        phi <= addOut;
      end else begin
        xIm <= addOut;
        xRe <= xReBuf;
      end

    end // if (run1_q==0) ... else
  end // always

endmodule
//=========================================================================================

