//====================================================================================
//  Copyright (C) BAY9, 2016
//====================================================================================
//
// MODULE:
//   cpExt
//
// ----------------------------------------------------------------------------------------
// ----------------------------------------------------------------------------------------

module cpExt(y, y_or, y_ff, y_we, 
             x, x_ir, x_fe, x_re, 
             run1, 
             regBus, regWe, regRe, regWeOut, regReOut, clk1, clk2, reset);

  // --------------------------------------------------------------------------------------
  // Module parameters
  parameter y_w               = 0;
  parameter x_w               = 0;

  parameter run1_w            = 0;

  parameter w                 = 0;

  parameter cpBuf_w           = 0;
  parameter cpBuf_n           = 0;
  parameter cpBuf_m           = 0;

  // --------------------------------------------------------------------------------------
  // Inputs and outputs
  output            [y_w-1:0]  y;
  output                       y_or;
  input                        y_ff;
  output                       y_we;
  assign                       y_we = y_or & ~y_ff;

  input             [x_w-1:0]  x;
  output                       x_ir;
  input                        x_fe;
  output                       x_re;
  assign                       x_re = x_ir & ~x_fe;

  input          [run1_w-1:0]  run1;

  // Define clock and reset
  input                        clk1;
  input                        clk2;
  input                        reset;

  // Inputs and outputs for registers
  inout                [15:0]  regBus;
  input                        regWe;
  input                        regRe;
  output                       regWeOut;
  output                       regReOut;

  // Wires for internal memories
  wire          [cpBuf_w-1:0]  cpBuf_q;
  wire          [cpBuf_w-1:0]  cpBuf_d;
  wire          [cpBuf_m-1:0]  cpBuf_adr;
  wire                         cpBuf_we;

  // Assign clock
  wire clk;
  assign clk = clk1;

  // --------------------------------------------------------------------------------------
  // External status registers
  // --------------------------------------------------------------------------------------
  // Internal single ported memories
  spRam1 cpBuf(cpBuf_q, cpBuf_d, cpBuf_adr, cpBuf_we, clk);
  defparam cpBuf.w    = cpBuf_w;
  defparam cpBuf.n    = cpBuf_n;
  defparam cpBuf.m    = cpBuf_m;

  // --------------------------------------------------------------------------------------
  // Included instances
  `include "buf1_20.v"

  // --------------------------------------------------------------------------------------
  // Define connections
  assign y                         = buf1_20_y;
  assign y_or                      = buf1_20_y_or;
  assign buf1_20_y_ff              = y_ff;


  // --------------------------------------------------------------------------------------
  // Define register control output
  assign regWeOut = 0 | buf1_20_regWe;
  assign regReOut = 0 | buf1_20_regRe;

// ----------------------------------------------------------------------------------------
//=========================================================================================

  // --------------------------------------------------------------------------------------
  // Register definitions
  reg            [6:0]  smplCnt;     // Sample counter                               
  wire           [6:0]  smplCntP1;   // Sample counter + 1                           
  wire                  cpBufWr;     // Indicates address range for writing buffer   

  wire       [y_w-1:0]  yP;                     // Preliminary output
  wire                  yP_we, yP_or, yP_ff;  // before buffering
  
  // --------------------------------------------------------------------------
  // Copy this autogenerated stuff to avoid non-causal use of yP
  assign buf1_20_x                 = yP;
  assign buf1_20_x_fe              = ~yP_or;
  assign yP_ff                     = ~buf1_20_x_ir;

  // --------------------------------------------------------------------------
  // Assign input and output enable
  assign x_ir   = run1 & (yP_ff==0 & smplCnt[6]==0); 
  assign yP_or  = run1 & ( x_fe==0 | smplCnt[6]==1);
  assign yP_we  = yP_or & ~yP_ff;
  assign yP     = (smplCnt[6]==0) ? x : cpBuf_q;
  
  // Output buffer control
  assign buf1_20_run1 = run1;
    
  // --------------------------------------------------------------------------
  // Memory connection
  assign cpBufWr   = smplCnt[6:4]==0;
  assign cpBuf_d   = x;
  assign cpBuf_adr = (cpBufWr | yP_we==0) ? smplCnt[3:0] : smplCntP1[3:0];
  assign cpBuf_we  = x_re & cpBufWr;
  
  assign smplCntP1 = smplCnt+1;
  
  // --------------------------------------------------------------------------
  //FSM-feedback
  always @(posedge clk) begin

    // Reset
    if (run1==0) begin
      smplCnt <= 0;
    end else
    
    // Normal operation, count 0..79
    if (yP_we) begin

      if (smplCnt==79) begin      // At the end of the OFDM symbol
        smplCnt <= 0;             // smplCnt 79 -> 0
      end else begin
        smplCnt <= smplCntP1;
      end // if (smplCnt==79) ...

    end // if (yP_we) begin
  end // always

endmodule
//=========================================================================================

