//====================================================================================
//  Copyright (C) BAY9, 2016
//====================================================================================
//
// MODULE:
//   cDeIntlv
//
// ----------------------------------------------------------------------------------------
// ----------------------------------------------------------------------------------------

module cDeIntlv(y, y_or, y_ff, y_we, 
                x, x_ir, x_fe, x_re, 
                run1, 
                regBus, regWe, regRe, regWeOut, regReOut, clk1, clk2, reset);

  // --------------------------------------------------------------------------------------
  // Module parameters
  parameter y_w               = 0;
  parameter x_w               = 0;

  parameter run1_w            = 0;

  parameter w                 = 0;

  parameter cBuf_w            = 0;
  parameter cBuf_n            = 0;
  parameter cBuf_m            = 0;

  // --------------------------------------------------------------------------------------
  // Inputs and outputs
  output            [y_w-1:0]  y;
  output                       y_or;
  input                        y_ff;
  output                       y_we;
  assign                       y_we = y_or & ~y_ff;

  input             [x_w-1:0]  x;
  output                       x_ir;
  input                        x_fe;
  output                       x_re;
  assign                       x_re = x_ir & ~x_fe;

  input          [run1_w-1:0]  run1;

  // Define clock and reset
  input                        clk1;
  input                        clk2;
  input                        reset;

  // Inputs and outputs for registers
  inout                [15:0]  regBus;
  input                        regWe;
  input                        regRe;
  output                       regWeOut;
  output                       regReOut;

  // Wires for internal memories
  wire           [cBuf_w-1:0]  cBuf_q;
  wire           [cBuf_w-1:0]  cBuf_d;
  wire           [cBuf_m-1:0]  cBuf_rdAdr;
  wire           [cBuf_m-1:0]  cBuf_wrAdr;
  wire                         cBuf_we;

  // Assign clock
  wire clk;
  assign clk = clk1;

  // --------------------------------------------------------------------------------------
  // External status registers
  // --------------------------------------------------------------------------------------
  // Internal dual ported memories
  dpRam1 cBuf(cBuf_q, cBuf_d, cBuf_rdAdr, cBuf_wrAdr, cBuf_we, clk);
  defparam cBuf.w    = cBuf_w;
  defparam cBuf.n    = cBuf_n;
  defparam cBuf.m    = cBuf_m;

  // --------------------------------------------------------------------------------------
  // Define register control output
  assign regWeOut = 0;
  assign regReOut = 0;

// ----------------------------------------------------------------------------------------
//=========================================================================================

  // --------------------------------------------------------------------------------------
  // Register definitions
  reg     [5:0] cntIn, cntOut;
  reg     [5:0] adrIn;
  wire    [5:0] cntOutP1;
  reg     [1:0] fsmOutEn;   // 0=stop, 1=run, 2=halt 
  reg           fsmInEn;
  
  // --------------------------------------------------------------------------------------
  // Assign input and output enable
  assign x_ir = fsmInEn;
  
  // --------------------------------------------------------------------------------------
  // Get input addresses
  always @(*) begin
    case (cntIn)
       0: adrIn =  4; // c-26
       1: adrIn = 20; // c-25
       2: adrIn = 36; // c-24
       3: adrIn =  5; // c-23
       4: adrIn = 21; // c-22
       5: adrIn =  0; // c-21 -> p0
       6: adrIn = 37; // c-20
       7: adrIn =  6; // c-19
       8: adrIn = 22; // c-18
       9: adrIn = 38; // c-17
      10: adrIn =  7; // c-16
      11: adrIn = 23; // c-15
      12: adrIn = 39; // c-14
      13: adrIn =  8; // c-13
      14: adrIn = 24; // c-12
      15: adrIn = 40; // c-11
      16: adrIn =  9; // c-10
      17: adrIn = 25; // c-09
      18: adrIn = 41; // c-08
      19: adrIn =  1; // c-07 -> p1
      20: adrIn = 10; // c-06
      21: adrIn = 26; // c-05
      22: adrIn = 42; // c-04
      23: adrIn = 11; // c-03
      24: adrIn = 27; // c-02
      25: adrIn = 43; // c-01
      26: adrIn = 12; // c+01
      27: adrIn = 28; // c+02
      28: adrIn = 44; // c+03
      29: adrIn = 13; // c+04
      30: adrIn = 29; // c+05
      31: adrIn = 45; // c+06
      32: adrIn =  2; // c+07 -> p2
      33: adrIn = 14; // c+08
      34: adrIn = 30; // c+09
      35: adrIn = 46; // c+10
      36: adrIn = 15; // c+11
      37: adrIn = 31; // c+12
      38: adrIn = 47; // c+13
      39: adrIn = 16; // c+14
      40: adrIn = 32; // c+15 
      41: adrIn = 48; // c+16
      42: adrIn = 17; // c+17
      43: adrIn = 33; // c+18
      44: adrIn = 49; // c+19
      45: adrIn = 18; // c+20
      46: adrIn =  3; // c+21 -> p3
      47: adrIn = 34; // c+22
      48: adrIn = 50; // c+23
      49: adrIn = 19; // c+24
      50: adrIn = 35; // c+25
      51: adrIn = 51; // c+26
      default: adrIn = 0;
    endcase
    
  end

  // --------------------------------------------------------------------------------------
  // FSM - input
  always @(posedge clk) begin
    
    // Reset
    if (run1==0) begin
      cntIn   <= 0;
      fsmInEn <= 0;
      
    // Normal operation
    end else begin
      
      // Get input FSM run on/off
      if (cntIn==0 && fsmOutEn==0) begin
        fsmInEn <= 1;
      end else 
      if (cntIn==51 && x_re) begin
        fsmInEn <= 0;
      end

      // Update input counter
      if (x_re) begin
        if (cntIn != 51) begin
          cntIn <= cntIn + 1;
        end else begin
          cntIn <= 0;
        end
      end

    end // if (run1_q==0) ... else
  end // always

  // -----------------------------------
  // Connect DPRAM input
  assign cBuf_d     = x;
  assign cBuf_we    = x_re;
  assign cBuf_wrAdr = adrIn;

  assign cntOutP1 = cntOut + 1;   

  // --------------------------------------------------------------------------------------
  // FSM - output
  always @(posedge clk) begin
    
    // Reset
    if (run1==0) begin
      cntOut      <= 0;
      fsmOutEn    <= 0;
      
    // Normal operation
    end else begin
      
      // Enable / disable output FSM
      if (fsmOutEn==0 && cBuf_wrAdr==3 && x_re) begin
        fsmOutEn <= 1;
      end else
      if (fsmOutEn==1 && cntOut==3 && y_we && fsmInEn==1) begin
        fsmOutEn <= 2;
      end else
      if (fsmOutEn==2 && fsmInEn==0) begin
        fsmOutEn <= 1;
      end else
      if (fsmOutEn==1 && cntOut==51 && y_we) begin
        fsmOutEn <= 0;
      end 
    
      // Update output counter
      if (y_we) begin
        if (cntOut != 51) begin
          cntOut <= cntOutP1;
        end else begin
          cntOut <= 0;
        end
      end
      
    end
  end
    
  // -----------------------------------
  // Connect output
  assign cBuf_rdAdr   = y_we ? cntOutP1 : cntOut;
  assign y            = cBuf_q;
  assign y_or         = fsmOutEn==1;
  
endmodule
//=========================================================================================

