//====================================================================================
//  Copyright (C) BAY9, 2016
//====================================================================================
//
// MODULE:
//   c8To16
//
// ----------------------------------------------------------------------------------------
// ----------------------------------------------------------------------------------------

module c8To16(y, y_or, y_ff, y_we, 
              x, x_ir, x_fe, x_re, 
              regBus, regWe, regRe, regWeOut, regReOut, clk1, clk2, reset);

  // --------------------------------------------------------------------------------------
  // Module parameters
  parameter y_w               = 0;
  parameter x_w               = 0;


  parameter run1_w            = 0;
  parameter run1_r            = 0;
  parameter run1_s            = 0;
  parameter R_run1            = 0;
  parameter nByte_w           = 0;
  parameter nByte_r           = 0;
  parameter nByte_s           = 0;
  parameter R_nByte           = 0;

  // --------------------------------------------------------------------------------------
  // Inputs and outputs
  output            [y_w-1:0]  y;
  output                       y_or;
  input                        y_ff;
  output                       y_we;
  assign                       y_we = y_or & ~y_ff;

  input             [x_w-1:0]  x;
  output                       x_ir;
  input                        x_fe;
  output                       x_re;
  assign                       x_re = x_ir & ~x_fe;


  // Define clock and reset
  input                        clk1;
  input                        clk2;
  input                        reset;

  // Inputs and outputs for registers
  inout                [15:0]  regBus;
  input                        regWe;
  input                        regRe;
  output                       regWeOut;
  output                       regReOut;

  // Wires for external registers
  wire           [run1_w-1:0]  run1_q;
  wire           [run1_w-1:0]  run1_d;
  wire                         run1_weint;
  assign                       run1_weint = 0;

  wire          [nByte_w-1:0]  nByte_q;
  wire          [nByte_w-1:0]  nByte_d;
  wire                         nByte_weint;

  // Assign clock
  wire clk;
  assign clk = clk1;

  // --------------------------------------------------------------------------------------
  // External status registers
  ereg run1(run1_q, regBus, run1_d, run1_weint, regWe, regRe, clk, reset);
  defparam run1.w    = run1_w;
  defparam run1.rval = run1_r;
  defparam run1.sgn  = run1_s;
  defparam run1.adr  = R_run1;

  ereg nByte(nByte_q, regBus, nByte_d, nByte_weint, regWe, regRe, clk, reset);
  defparam nByte.w    = nByte_w;
  defparam nByte.rval = nByte_r;
  defparam nByte.sgn  = nByte_s;
  defparam nByte.adr  = R_nByte;

  // --------------------------------------------------------------------------------------
  // Define register control output
  assign regWeOut = 0;
  assign regReOut = 0;

// ----------------------------------------------------------------------------------------
//=========================================================================================

  // --------------------------------------------------------------------------------------
  // Register definitions
  reg     [15:0]  xD;
  reg      [1:0]  cnt;
    
  // --------------------------------------------------------------------------------------
  // Assign input enable
  assign x_ir = run1_q && nByte_q!=0 && (cnt!=2 || y_we);

  // Count down nByte
  assign nByte_d      = nByte_q-1;
  assign nByte_weint  = x_re;

  // --------------------------------------------------------------------------------------
  // FSM
  always @(posedge clk) begin
    
    // Reset
    if (run1_q==0) begin
      xD      <= 0;
      cnt     <= 0;
          
    // Normal operation
    end else begin
      
      // Ser -> Par
      if (x_re) begin
        if (cnt==0 || cnt==2) begin
          xD[7:0]   <= x;
          xD[15:8]  <= 8'hAA;
        end else begin
          xD[15:8] <= x;
        end
      end

      // Update counter
      if (y_we) begin
        if (x_re) begin
          cnt <= 1;
        end else begin
          cnt <= 0;
        end
      end else
      if (x_re) begin
        cnt <= cnt+1;
      end

    end // if (run1_q==0) ... else
  end // always

  // Set output
  assign y    = xD;
  assign y_or = cnt==2 || (cnt==1 && nByte_q==0);

endmodule
//=========================================================================================

