//====================================================================================
//  Copyright (C) BAY9, 2016
//====================================================================================
//
// MODULE:
//   agcMain
//
// ----------------------------------------------------------------------------------------
// ----------------------------------------------------------------------------------------

module agcMain(attn, attn_or, attn_ff, attn_we, 
               attnDb, attnDb_or, attnDb_ff, attnDb_we, 
               x, x_ir, x_fe, x_re, 
               ssAcqHalt, 
               ssDetect, 
               regBus, regWe, regRe, regWeOut, regReOut, clk1, clk2, reset);

  // --------------------------------------------------------------------------------------
  // Module parameters
  parameter attn_w            = 0;
  parameter attnDb_w          = 0;
  parameter x_w               = 0;

  parameter ssAcqHalt_w       = 0;
  parameter ssDetect_w        = 0;

  parameter run1_w            = 0;
  parameter run1_r            = 0;
  parameter run1_s            = 0;
  parameter R_run1            = 0;
  parameter numSteps_w        = 0;
  parameter numSteps_r        = 0;
  parameter numSteps_s        = 0;
  parameter R_numSteps        = 0;
  parameter attnCur_w         = 0;
  parameter attnCur_r         = 0;
  parameter attnCur_s         = 0;
  parameter R_attnCur         = 0;
  parameter attnCurReal_w     = 0;
  parameter attnCurReal_r     = 0;
  parameter attnCurReal_s     = 0;
  parameter R_attnCurReal     = 0;
  parameter attnInit_w        = 0;
  parameter attnInit_r        = 0;
  parameter attnInit_s        = 0;
  parameter R_attnInit        = 0;
  parameter attnTest_w        = 0;
  parameter attnTest_r        = 0;
  parameter attnTest_s        = 0;
  parameter R_attnTest        = 0;
  parameter backOffTgt_w      = 0;
  parameter backOffTgt_r      = 0;
  parameter backOffTgt_s      = 0;
  parameter R_backOffTgt      = 0;
  parameter attnInitUpdt_w    = 0;
  parameter attnInitUpdt_r    = 0;
  parameter attnInitUpdt_s    = 0;
  parameter R_attnInitUpdt    = 0;
  parameter thrLo_w           = 0;
  parameter thrLo_r           = 0;
  parameter thrLo_s           = 0;
  parameter R_thrLo           = 0;
  parameter thrHi_w           = 0;
  parameter thrHi_r           = 0;
  parameter thrHi_s           = 0;
  parameter R_thrHi           = 0;
  parameter thrX_w            = 0;
  parameter thrX_r            = 0;
  parameter thrX_s            = 0;
  parameter R_thrX            = 0;
  parameter stepDb_w          = 0;
  parameter stepDb_r          = 0;
  parameter stepDb_s          = 0;
  parameter R_stepDb          = 0;
  parameter waitSettle_w      = 0;
  parameter waitSettle_r      = 0;
  parameter waitSettle_s      = 0;
  parameter R_waitSettle      = 0;
  parameter waitFinal_w       = 0;
  parameter waitFinal_r       = 0;
  parameter waitFinal_s       = 0;
  parameter R_waitFinal       = 0;

  parameter wx                = 0;
  parameter ws                = 0;
  parameter waitTimeOut       = 0;
  parameter attnMax           = 0;
  parameter numSmplRssi       = 0;
  parameter StReset           = 0;
  parameter StSearch          = 0;
  parameter StStep            = 0;
  parameter StFine            = 0;
  parameter StTestAttn        = 0;
  parameter StWait            = 0;
  parameter StDone            = 0;
  parameter StWaitSettle0     = 0;
  parameter StWaitSettle1     = 0;
  parameter StWaitSettle2     = 0;
  parameter StWaitSettle3     = 0;

  // --------------------------------------------------------------------------------------
  // Inputs and outputs
  output         [attn_w-1:0]  attn;
  output                       attn_or;
  input                        attn_ff;
  output                       attn_we;
  assign                       attn_we = attn_or & ~attn_ff;

  output       [attnDb_w-1:0]  attnDb;
  output                       attnDb_or;
  input                        attnDb_ff;
  output                       attnDb_we;
  assign                       attnDb_we = attnDb_or & ~attnDb_ff;

  input             [x_w-1:0]  x;
  output                       x_ir;
  input                        x_fe;
  output                       x_re;
  assign                       x_re = x_ir & ~x_fe;

  output    [ssAcqHalt_w-1:0]  ssAcqHalt;
  input      [ssDetect_w-1:0]  ssDetect;

  // Define clock and reset
  input                        clk1;
  input                        clk2;
  input                        reset;

  // Inputs and outputs for registers
  inout                [15:0]  regBus;
  input                        regWe;
  input                        regRe;
  output                       regWeOut;
  output                       regReOut;

  // Wires for external registers
  wire           [run1_w-1:0]  run1_q;
  wire           [run1_w-1:0]  run1_d;
  wire                         run1_weint;
  assign                       run1_weint = 0;

  wire       [numSteps_w-1:0]  numSteps_q;
  wire       [numSteps_w-1:0]  numSteps_d;
  wire                         numSteps_weint;

  wire        [attnCur_w-1:0]  attnCur_q;
  wire        [attnCur_w-1:0]  attnCur_d;
  wire                         attnCur_weint;

  wire    [attnCurReal_w-1:0]  attnCurReal_q;
  wire    [attnCurReal_w-1:0]  attnCurReal_d;
  wire                         attnCurReal_weint;

  wire       [attnInit_w-1:0]  attnInit_q;
  wire       [attnInit_w-1:0]  attnInit_d;
  wire                         attnInit_weint;

  wire       [attnTest_w-1:0]  attnTest_q;
  wire       [attnTest_w-1:0]  attnTest_d;
  wire                         attnTest_weint;
  assign                       attnTest_weint = 0;

  wire     [backOffTgt_w-1:0]  backOffTgt_q;
  wire     [backOffTgt_w-1:0]  backOffTgt_d;
  wire                         backOffTgt_weint;
  assign                       backOffTgt_weint = 0;

  wire   [attnInitUpdt_w-1:0]  attnInitUpdt_q;
  wire   [attnInitUpdt_w-1:0]  attnInitUpdt_d;
  wire                         attnInitUpdt_weint;
  assign                       attnInitUpdt_weint = 0;

  wire          [thrLo_w-1:0]  thrLo_q;
  wire          [thrLo_w-1:0]  thrLo_d;
  wire                         thrLo_weint;
  assign                       thrLo_weint = 0;

  wire          [thrHi_w-1:0]  thrHi_q;
  wire          [thrHi_w-1:0]  thrHi_d;
  wire                         thrHi_weint;
  assign                       thrHi_weint = 0;

  wire           [thrX_w-1:0]  thrX_q;
  wire           [thrX_w-1:0]  thrX_d;
  wire                         thrX_weint;
  assign                       thrX_weint = 0;

  wire         [stepDb_w-1:0]  stepDb_q;
  wire         [stepDb_w-1:0]  stepDb_d;
  wire                         stepDb_weint;
  assign                       stepDb_weint = 0;

  wire     [waitSettle_w-1:0]  waitSettle_q;
  wire     [waitSettle_w-1:0]  waitSettle_d;
  wire                         waitSettle_weint;
  assign                       waitSettle_weint = 0;

  wire      [waitFinal_w-1:0]  waitFinal_q;
  wire      [waitFinal_w-1:0]  waitFinal_d;
  wire                         waitFinal_weint;
  assign                       waitFinal_weint = 0;

  // Assign clock
  wire clk;
  assign clk = clk1;

  // --------------------------------------------------------------------------------------
  // External status registers
  ereg run1(run1_q, regBus, run1_d, run1_weint, regWe, regRe, clk, reset);
  defparam run1.w    = run1_w;
  defparam run1.rval = run1_r;
  defparam run1.sgn  = run1_s;
  defparam run1.adr  = R_run1;

  ereg numSteps(numSteps_q, regBus, numSteps_d, numSteps_weint, regWe, regRe, clk, reset);
  defparam numSteps.w    = numSteps_w;
  defparam numSteps.rval = numSteps_r;
  defparam numSteps.sgn  = numSteps_s;
  defparam numSteps.adr  = R_numSteps;

  ereg attnCur(attnCur_q, regBus, attnCur_d, attnCur_weint, regWe, regRe, clk, reset);
  defparam attnCur.w    = attnCur_w;
  defparam attnCur.rval = attnCur_r;
  defparam attnCur.sgn  = attnCur_s;
  defparam attnCur.adr  = R_attnCur;

  ereg attnCurReal(attnCurReal_q, regBus, attnCurReal_d, attnCurReal_weint, regWe, regRe, clk, reset);
  defparam attnCurReal.w    = attnCurReal_w;
  defparam attnCurReal.rval = attnCurReal_r;
  defparam attnCurReal.sgn  = attnCurReal_s;
  defparam attnCurReal.adr  = R_attnCurReal;

  ereg attnInit(attnInit_q, regBus, attnInit_d, attnInit_weint, regWe, regRe, clk, reset);
  defparam attnInit.w    = attnInit_w;
  defparam attnInit.rval = attnInit_r;
  defparam attnInit.sgn  = attnInit_s;
  defparam attnInit.adr  = R_attnInit;

  ereg attnTest(attnTest_q, regBus, attnTest_d, attnTest_weint, regWe, regRe, clk, reset);
  defparam attnTest.w    = attnTest_w;
  defparam attnTest.rval = attnTest_r;
  defparam attnTest.sgn  = attnTest_s;
  defparam attnTest.adr  = R_attnTest;

  ereg backOffTgt(backOffTgt_q, regBus, backOffTgt_d, backOffTgt_weint, regWe, regRe, clk, reset);
  defparam backOffTgt.w    = backOffTgt_w;
  defparam backOffTgt.rval = backOffTgt_r;
  defparam backOffTgt.sgn  = backOffTgt_s;
  defparam backOffTgt.adr  = R_backOffTgt;

  ereg attnInitUpdt(attnInitUpdt_q, regBus, attnInitUpdt_d, attnInitUpdt_weint, regWe, regRe, clk, reset);
  defparam attnInitUpdt.w    = attnInitUpdt_w;
  defparam attnInitUpdt.rval = attnInitUpdt_r;
  defparam attnInitUpdt.sgn  = attnInitUpdt_s;
  defparam attnInitUpdt.adr  = R_attnInitUpdt;

  ereg thrLo(thrLo_q, regBus, thrLo_d, thrLo_weint, regWe, regRe, clk, reset);
  defparam thrLo.w    = thrLo_w;
  defparam thrLo.rval = thrLo_r;
  defparam thrLo.sgn  = thrLo_s;
  defparam thrLo.adr  = R_thrLo;

  ereg thrHi(thrHi_q, regBus, thrHi_d, thrHi_weint, regWe, regRe, clk, reset);
  defparam thrHi.w    = thrHi_w;
  defparam thrHi.rval = thrHi_r;
  defparam thrHi.sgn  = thrHi_s;
  defparam thrHi.adr  = R_thrHi;

  ereg thrX(thrX_q, regBus, thrX_d, thrX_weint, regWe, regRe, clk, reset);
  defparam thrX.w    = thrX_w;
  defparam thrX.rval = thrX_r;
  defparam thrX.sgn  = thrX_s;
  defparam thrX.adr  = R_thrX;

  ereg stepDb(stepDb_q, regBus, stepDb_d, stepDb_weint, regWe, regRe, clk, reset);
  defparam stepDb.w    = stepDb_w;
  defparam stepDb.rval = stepDb_r;
  defparam stepDb.sgn  = stepDb_s;
  defparam stepDb.adr  = R_stepDb;

  ereg waitSettle(waitSettle_q, regBus, waitSettle_d, waitSettle_weint, regWe, regRe, clk, reset);
  defparam waitSettle.w    = waitSettle_w;
  defparam waitSettle.rval = waitSettle_r;
  defparam waitSettle.sgn  = waitSettle_s;
  defparam waitSettle.adr  = R_waitSettle;

  ereg waitFinal(waitFinal_q, regBus, waitFinal_d, waitFinal_weint, regWe, regRe, clk, reset);
  defparam waitFinal.w    = waitFinal_w;
  defparam waitFinal.rval = waitFinal_r;
  defparam waitFinal.sgn  = waitFinal_s;
  defparam waitFinal.adr  = R_waitFinal;

  // --------------------------------------------------------------------------------------
  // Included instances
  `include "lut_agc.v"
  `include "agcRssi_0.v"
  `include "attnSet_0.v"

  // --------------------------------------------------------------------------------------
  // Define connections
  assign agcRssi_0_x               = x;
  assign agcRssi_0_x_fe            = x_fe;
  assign x_ir                      = agcRssi_0_x_ir;


  // --------------------------------------------------------------------------------------
  // Define register control output
  assign regWeOut = 0 | lut_agc_regWe | agcRssi_0_regWe | attnSet_0_regWe;
  assign regReOut = 0 | lut_agc_regRe | agcRssi_0_regRe | attnSet_0_regRe;

// ----------------------------------------------------------------------------------------
//=========================================================================================

  // --------------------------------------------------------------------------------------
  // Register definitions
  reg    [3:0]  state,     state_nxt;       // Internal state
  reg    [2:0]  cntProc,   cntProc_nxt;     // Process counter
  reg    [2:0]  cntThrHi,  cntThrHi_nxt;    // Count thrHi exceeded
  reg    [0:0]  ssAcqHalt, ssAcqHalt_nxt;   // Halt indication for SS ACQ
  reg    [9:0]  cntWait;                    // Wait counter

  reg           ssDetectReg;              // Save SS detection from SS ACQ
  reg           attnSetImm,               // Immediate attenuation setting
                attnSetImmD;
        
  reg           attnOrR;

  // Registers used are wires
  reg    [7:0]  attnSetMax;       // Interface to attenuation setting
  reg    [7:0]  attnSetCur;
  reg    [7:0]  attnSetAdd;
  reg    [7:0]  attnSetSub;
  reg           attnSetStart;
   
  reg           rssiStart;        // Interface to RSSI calculation
  reg    [6:0]  rssiNumSmpl;
  reg           rssiAccSh;

  reg    [9:0]  cntWaitInit;      // Wait counter init
   
  reg    [7:0]  inP;              // Internal comparison
  reg    [7:0]  inM;
  wire   [7:0]  rssiCmp;
  wire          rssiTrigger;
  
  reg    [2:0] nStep;             // Debug information on number of AGC step
  reg          nStepSave;         // Write enable for number of AGC steps
  
  // --------------------------------------------------------------------------------------
  // Connect submodules
  assign agcRssi_0_run1     = run1_q!=0;
  assign agcRssi_0_start    = rssiStart;
  assign agcRssi_0_numSmpl  = rssiNumSmpl;
  assign agcRssi_0_accSh    = rssiAccSh;
  
  assign attnSet_0_run1     = run1_q!=0;
  assign attnSet_0_start    = attnSetStart;
  assign attnSet_0_attnCur  = attnSetCur;
  assign attnSet_0_attnAdd  = attnSetAdd;
  assign attnSet_0_attnSub  = attnSetSub;
  assign attnSet_0_attnMax  = attnSetMax;
 
  // --------------------------------------------------------------------------------------
  // AGC output setting using LUT
  assign lut_agc_adr  = attnSet_0_y;        // LUT input
  assign attn         = lut_agc_dat[22:7];  // LUT output
  
  // Set output ready
  always @(posedge clk) begin
    attnOrR <= attnSet_0_y_or;
  end
  assign attn_or = attnOrR;

  // Set output of attnDb
  assign attnDb_or = attn_or;
  assign attnDb    = attnSet_0_y;

  // Keep current attn setting in Ereg
  assign attnCur_d      = attnSet_0_y;
  assign attnCur_weint  = attnSet_0_y_or;
  
  // Save real attenuation from LUT
  assign attnCurReal_d      = lut_agc_dat[6:0];
  assign attnCurReal_weint  = attnOrR;
  
  // Update init attn setting
  assign attnInit_d     = attnSet_0_y;
  assign attnInit_weint = attnSet_0_y_or & attnInitUpdt_q & state==StWaitSettle0;
  
  // Update numSteps debug info
  assign numSteps_d     = nStep;
  assign numSteps_weint = run1_q==0 | run1_q==1 | nStepSave;
  
  // --------------------------------------------------------------------------------------
  // FSM for immediate attenuation setting
  always @(posedge clk) begin
    attnSetImm  <= (regBus==R_run1 | regBus==R_attnInit) & regWe;
    attnSetImmD <= attnSetImm;
  end
  
  // --------------------------------------------------------------------------------------
  // FSM
  always @(posedge clk) begin
    
    // -------------------------------------------------------------------------
    // Reset
    if (run1_q==0 | run1_q==1) begin
      state         <= StReset;
      cntWait       <= 0;
      cntProc       <= 0;
      cntThrHi      <= 0;
      ssDetectReg   <= 0;
      ssAcqHalt     <= 0;
    end else 
    
    // -------------------------------------------------------------------------
    // Normal operation
    if (run1_q==2 | run1_q==3) begin
      
      // -----------------------------------------
      // Register + keep SS detection if it happens
      if (ssDetect) begin
        ssDetectReg <= 1;
      end
     
      // -----------------------------------------
      // Wait a certain number of samples for AGC settling
      if (cntWaitInit!=0) begin
        cntWait <= cntWaitInit;
      end else
      if (cntWait!=0 & x_re) begin
        cntWait <= cntWait-1;
      end
     
      // -----------------------------------------
      // Main FSM - Feedback
      ssAcqHalt <=  ssAcqHalt_nxt;
      cntThrHi  <=  cntThrHi_nxt;
      cntProc   <=  cntProc_nxt;
      state     <=  state_nxt;

    end // if (run1_q==0) ... else
  end // always @(posedge clk) begin
  
  // --------------------------------------------------------------------------------------
  // Internal comparison + trigger
  assign rssiCmp     = inP - inM;
  assign rssiTrigger = rssiCmp[7];
    
  // --------------------------------------------------------------------------------------
  // FSM output + feedback / combinatorial logic
  always @(*) begin
    
    // Default settings
    state_nxt       = state;          // Keep old states unless set otherwise
    cntProc_nxt     = cntProc; 
    cntThrHi_nxt    = cntThrHi;
    ssAcqHalt_nxt   = ssAcqHalt;

    attnSetMax      = attnMax;        // Attenuation setting variables
    attnSetCur      = 0;
    attnSetAdd      = 0;
    attnSetSub      = 0;  
    attnSetStart    = 0;
    
    rssiStart       = 0;              // RSSI measurement variables
    rssiNumSmpl     = numSmplRssi;    // Use fixed value, state dependent is uncommented now
    rssiAccSh       = 0;
    
    cntWaitInit     = 0;              // Wait counter init
    
    inP             = 0;              // RSSI comparison variables
    inM             = 0;
    
    nStep           = 0;              // Debug information on current AGC step
    nStepSave       = 0;              // -> Trigger saving of debug info
    
    // Fixed gain setting -> run upon immediate flag
    if (run1_q==1) begin
      if (attnSetImmD) begin
        attnSetCur     = attnInit_q;
        attnSetAdd     = 0;
        attnSetSub     = 0;  
        attnSetStart   = 1;     // Possibly use delayed value later
      end
    end else
    
    // Normal AGC operation
    if (run1_q==2 | run1_q==3) begin

      // Set initial gain after reset
      if (state==StReset) begin
        attnSetCur    = attnInit_q;
        attnSetAdd    = 0;
        attnSetSub    = 0;
        attnSetStart  = 1;
        cntWaitInit   = waitSettle_q;
        state_nxt     = StWaitSettle0;
      end else

      // Start measurement after wait
      if (state==StWaitSettle0) begin
        if (cntWait==1) begin
          rssiStart   = 1;
          //rssiNumSmpl = numSmplRssi;
          rssiAccSh   = 0;
          state_nxt   = StSearch;
        end
      end else

      // Start final measurement if SS detection
      if (state==StSearch) begin

        // Short symbol detection
        if (ssDetectReg) begin
          if (run1_q==2) begin
            attnSetCur    = attnCurReal_q;
            attnSetAdd    = backOffTgt_q;
            attnSetSub    = agcRssi_0_y;
            attnSetStart  = 1;
            cntWaitInit   = 3;            // Wait a short moment
            nStep         = 1;
            nStepSave     = 1;
          end else begin
            attnSetCur    = attnTest_q;   // Set test AGC directly
            attnSetAdd    = 0;
            attnSetSub    = 0;
            attnSetStart  = 1;
            cntWaitInit   = 3;
          end
          ssAcqHalt_nxt = 1;               // Halt Acq
          cntThrHi_nxt  = 0;
          cntProc_nxt   = 0;
          state_nxt     = StTestAttn;
        end else
        
        // Check RSSI > thrX
        if (agcRssi_0_y_or & run1_q==2) begin
          inP = agcRssi_0_y;
          inM = thrX_q;
          if (rssiTrigger) begin
            attnSetCur    = attnCur_q;
            attnSetAdd    = stepDb_q;
            attnSetSub    = 0;
            attnSetStart  = 1;
            cntWaitInit   = waitSettle_q;
            state_nxt     = StWaitSettle1;
            ssAcqHalt_nxt = 1;
            cntThrHi_nxt  = 0;
          end else begin
            cntProc_nxt   = cntProc+1;
          end
        end else
              
        // Check RSSI > thrHi
        if (cntProc==1) begin
          inP = agcRssi_0_y;
          inM = thrHi_q;
          if (rssiTrigger) begin
            if (cntThrHi==5) begin
              attnSetCur    = attnCur_q;
              attnSetAdd    = 1;
              attnSetSub    = 0;
              attnSetStart  = 1;
              cntWaitInit   = waitSettle_q;
              state_nxt     = StWaitSettle0;
              cntProc_nxt   = 0;
              cntThrHi_nxt  = 0;
            end else begin
              cntProc_nxt   = cntProc+1;
              cntThrHi_nxt  = cntThrHi+1;
            end
          end else begin
            cntProc_nxt = cntProc+1;
          end
        end else

        // Check RSSI < thrLo
        if (cntProc==2) begin
          inP = thrLo_q;
          inM = agcRssi_0_y;
          if (rssiTrigger & attnCur_q!=0) begin
            attnSetCur    = attnCur_q;
            attnSetAdd    = 0;
            attnSetSub    = 2;
            attnSetStart  = 1;
            cntWaitInit   = waitSettle_q;
            state_nxt     = StWaitSettle0;
            cntProc_nxt   = 0;
            cntThrHi_nxt  = 0;
          end else begin
            cntProc_nxt   = cntProc+1;
          end
        end else
      
        // Restart RSSI measurement if nothing happened
        if (cntProc==3) begin
          rssiStart   = 1;
          //rssiNumSmpl = numSmplRssi;
          rssiAccSh   = 0;
          cntProc_nxt = 0;
        end
        
      end else
      
      // Start RSSI measurement after step 1
      if (state==StWaitSettle1) begin
        if (cntWait==1) begin
          rssiStart   = 1;
          //rssiNumSmpl = numSmplRssi;
          rssiAccSh   = 0;
          state_nxt   = StStep;
        end
      end else

      // Main FSM - After 1st step: RSSI > thrX ?
      if (state==StStep) begin
        if (agcRssi_0_y_or) begin
          inP = agcRssi_0_y;
          inM = thrX_q;
          if (rssiTrigger) begin            // One more step 
            attnSetCur    = attnCur_q;
            attnSetAdd    = stepDb_q;
            attnSetSub    = 0;
            attnSetStart  = 1;
            cntWaitInit   = waitSettle_q;
            nStep         = 3;
            nStepSave     = 1;
            state_nxt     = StWaitSettle2;     // -> Set -25 dB + wait for settling
          end else begin
            attnSetCur    = attnCurReal_q;
            attnSetAdd    = backOffTgt_q;
            attnSetSub    = agcRssi_0_y;
            attnSetStart  = 1;
            cntWaitInit   = waitFinal_q;
            nStep         = 2;
            nStepSave     = 1;
            state_nxt     = StWaitSettle3;     // -> Set final + wait for settling
          end
        end
      end else

      // Start RSSI final measurement
      if (state==StWaitSettle2) begin
        if (cntWait==1) begin
          rssiStart   = 1;
          //rssiNumSmpl = numSmplRssi;
          rssiAccSh   = 0;
          state_nxt   = StFine;              // -> Start final measurement
        end
      end else
    
      // Main FSM - Set AGC after final measurement
      if (state==StFine) begin
        if (agcRssi_0_y_or) begin
          attnSetCur    = attnCurReal_q;
          attnSetAdd    = backOffTgt_q;
          attnSetSub    = agcRssi_0_y;
          attnSetStart  = 1;
          cntWaitInit   = waitFinal_q;
          state_nxt     = StWaitSettle3;      // -> Apply and wait for settling
        end
      end else
      
      // Either go directly to the wait state wait for final settling
      if (state==StTestAttn) begin
        if (cntWait==1) begin
          if (attnCur_q==attnInit_q) begin        
            cntWaitInit   = waitTimeOut;
            ssAcqHalt_nxt = 0;               // -> Release ACQ halt, start timer
            state_nxt     = StWait;
          end else begin
            cntWaitInit = waitFinal_q;
            state_nxt   = StWaitSettle3;
          end
        end
      end else
      
      // Start timeout after final setting -> really needs 2 process cycles ??
      if (state==StWaitSettle3) begin
        if (cntWait==1) begin
          cntWaitInit   = waitTimeOut;
          ssAcqHalt_nxt = 0;               // -> Release ACQ halt, start timer
          state_nxt     = StWait;          // -> Start timer
        end
      end else

      // Start search measurement if timeout
      if (state==StWait) begin
        if (ssDetectReg) begin
          state_nxt = StDone;
        end else
        if (cntWait==1) begin
          rssiStart   = 1;
          //rssiNumSmpl = numSmplRssi;
          rssiAccSh   = 0;
          state_nxt   = StSearch;
        end
      end
    
    end // if (run1_q==2...)
  end // always @(*)     

  // Test
//  assign dbgLed = state;

endmodule
//=========================================================================================

