//====================================================================================
//  Copyright (C) BAY9, 2016
//====================================================================================
//
// MODULE:
//   acq11a
//
// ----------------------------------------------------------------------------------------
// ----------------------------------------------------------------------------------------

module acq11a(yCor2, yCor2_or, yCor2_ff, yCor2_we, 
              yCor3, yCor3_or, yCor3_ff, yCor3_we, 
              yCor4, yCor4_or, yCor4_ff, yCor4_we, 
              yAbs, yAbs_or, yAbs_ff, yAbs_we, 
              yPh, yPh_or, yPh_ff, yPh_we, 
              x, x_ir, x_fe, x_re, 
              irqSsDet, 
              irqSsEnd, 
              run1, 
              ssAcqHalt, 
              regBus, regWe, regRe, regWeOut, regReOut, clk1, clk2, reset);

  // --------------------------------------------------------------------------------------
  // Module parameters
  parameter yCor2_w           = 0;
  parameter yCor3_w           = 0;
  parameter yCor4_w           = 0;
  parameter yAbs_w            = 0;
  parameter yPh_w             = 0;
  parameter x_w               = 0;

  parameter irqSsDet_w        = 0;
  parameter irqSsEnd_w        = 0;
  parameter run1_w            = 0;
  parameter ssAcqHalt_w       = 0;

  parameter freqOff_w         = 0;
  parameter freqOff_r         = 0;
  parameter freqOff_s         = 0;
  parameter R_freqOff         = 0;
  parameter timeOff_w         = 0;
  parameter timeOff_r         = 0;
  parameter timeOff_s         = 0;
  parameter R_timeOff         = 0;
  parameter ampEst_w          = 0;
  parameter ampEst_r          = 0;
  parameter ampEst_s          = 0;
  parameter R_ampEst          = 0;

  parameter wx                = 0;
  parameter wc                = 0;
  parameter wa                = 0;
  parameter wp                = 0;
  parameter waitSmpl          = 0;
  parameter StWaitAvgDet      = 0;
  parameter StWait            = 0;
  parameter StWaitPreambleEnd = 0;
  parameter StAcqDone         = 0;

  parameter ctfeCnt_w         = 0;
  parameter ctfeCnt_n         = 0;
  parameter ctfeCnt_m         = 0;
  parameter ssCorCnt_w        = 0;
  parameter ssCorCnt_n        = 0;
  parameter ssCorCnt_m        = 0;
  parameter waitCnt_w         = 0;
  parameter waitCnt_n         = 0;
  parameter waitCnt_m         = 0;
  parameter stateAcq_w        = 0;
  parameter stateAcq_n        = 0;
  parameter stateAcq_m        = 0;
  parameter yPhD_w            = 0;
  parameter yPhD_n            = 0;
  parameter yPhD_m            = 0;

  // --------------------------------------------------------------------------------------
  // Inputs and outputs
  output        [yCor2_w-1:0]  yCor2;
  output                       yCor2_or;
  input                        yCor2_ff;
  output                       yCor2_we;
  assign                       yCor2_we = yCor2_or & ~yCor2_ff;

  output        [yCor3_w-1:0]  yCor3;
  output                       yCor3_or;
  input                        yCor3_ff;
  output                       yCor3_we;
  assign                       yCor3_we = yCor3_or & ~yCor3_ff;

  output        [yCor4_w-1:0]  yCor4;
  output                       yCor4_or;
  input                        yCor4_ff;
  output                       yCor4_we;
  assign                       yCor4_we = yCor4_or & ~yCor4_ff;

  output         [yAbs_w-1:0]  yAbs;
  output                       yAbs_or;
  input                        yAbs_ff;
  output                       yAbs_we;
  assign                       yAbs_we = yAbs_or & ~yAbs_ff;

  output          [yPh_w-1:0]  yPh;
  output                       yPh_or;
  input                        yPh_ff;
  output                       yPh_we;
  assign                       yPh_we = yPh_or & ~yPh_ff;

  input             [x_w-1:0]  x;
  output                       x_ir;
  input                        x_fe;
  output                       x_re;
  assign                       x_re = x_ir & ~x_fe;

  output     [irqSsDet_w-1:0]  irqSsDet;
  output     [irqSsEnd_w-1:0]  irqSsEnd;
  input          [run1_w-1:0]  run1;
  input     [ssAcqHalt_w-1:0]  ssAcqHalt;

  // Define clock and reset
  input                        clk1;
  input                        clk2;
  input                        reset;

  // Inputs and outputs for registers
  inout                [15:0]  regBus;
  input                        regWe;
  input                        regRe;
  output                       regWeOut;
  output                       regReOut;

  // Wires for external registers
  wire        [freqOff_w-1:0]  freqOff_q;
  wire        [freqOff_w-1:0]  freqOff_d;
  wire                         freqOff_weint;

  wire        [timeOff_w-1:0]  timeOff_q;
  wire        [timeOff_w-1:0]  timeOff_d;
  wire                         timeOff_weint;

  wire         [ampEst_w-1:0]  ampEst_q;
  wire         [ampEst_w-1:0]  ampEst_d;
  wire                         ampEst_weint;

  // Assign clock
  wire clk;
  assign clk = clk1;

  // --------------------------------------------------------------------------------------
  // External status registers
  ereg freqOff(freqOff_q, regBus, freqOff_d, freqOff_weint, regWe, regRe, clk, reset);
  defparam freqOff.w    = freqOff_w;
  defparam freqOff.rval = freqOff_r;
  defparam freqOff.sgn  = freqOff_s;
  defparam freqOff.adr  = R_freqOff;

  ereg timeOff(timeOff_q, regBus, timeOff_d, timeOff_weint, regWe, regRe, clk, reset);
  defparam timeOff.w    = timeOff_w;
  defparam timeOff.rval = timeOff_r;
  defparam timeOff.sgn  = timeOff_s;
  defparam timeOff.adr  = R_timeOff;

  ereg ampEst(ampEst_q, regBus, ampEst_d, ampEst_weint, regWe, regRe, clk, reset);
  defparam ampEst.w    = ampEst_w;
  defparam ampEst.rval = ampEst_r;
  defparam ampEst.sgn  = ampEst_s;
  defparam ampEst.adr  = R_ampEst;

  // --------------------------------------------------------------------------------------
  // Internal status registers
  reg         [ctfeCnt_w-1:0]  ctfeCnt;
  reg        [ssCorCnt_w-1:0]  ssCorCnt;
  reg         [waitCnt_w-1:0]  waitCnt;
  reg        [stateAcq_w-1:0]  stateAcq;
  reg            [yPhD_w-1:0]  yPhD[yPhD_n-1:0];

  // --------------------------------------------------------------------------------------
  // Included instances
  `include "ssNorm_0.v"
  `include "ssCcf_0.v"
  `include "ssCcfAbs_0.v"
  `include "ssCcfAvgDet_0.v"
  `include "ctfe_0.v"
  `include "s1To2And_10.v"
  `include "buf2_9.v"

  // --------------------------------------------------------------------------------------
  // Define connections
  assign ssNorm_0_x                = x;
  assign ssNorm_0_x_fe             = x_fe;
  assign x_ir                      = ssNorm_0_x_ir;

  assign s1To2And_10_x             = ssNorm_0_y;
  assign s1To2And_10_x_fe          = ~ssNorm_0_y_or;
  assign ssNorm_0_y_ff             = ~s1To2And_10_x_ir;

  assign ssCcf_0_x                 = s1To2And_10_y0;
  assign ssCcf_0_x_fe              = ~s1To2And_10_y0_or;
  assign s1To2And_10_y0_ff         = ~ssCcf_0_x_ir;

  assign ctfe_0_x                  = s1To2And_10_y1;
  assign ctfe_0_x_fe               = ~s1To2And_10_y1_or;
  assign s1To2And_10_y1_ff         = ~ctfe_0_x_ir;

  assign ssCcfAbs_0_x              = ssCcf_0_y;
  assign ssCcfAbs_0_x_fe           = ~ssCcf_0_y_or;
  assign ssCcf_0_y_ff              = ~ssCcfAbs_0_x_ir;

  assign ssCcfAvgDet_0_x           = ssCcfAbs_0_y;
  assign ssCcfAvgDet_0_x_fe        = ~ssCcfAbs_0_y_or;
  assign ssCcfAbs_0_y_ff           = ~ssCcfAvgDet_0_x_ir;

  assign buf2_9_x                  = ssNorm_0_yAmp;
  assign buf2_9_x_fe               = ~ssNorm_0_yAmp_or;
  assign ssNorm_0_yAmp_ff          = ~buf2_9_x_ir;

  assign yCor2                     = ssCcfAvgDet_0_y2;
  assign yCor2_or                  = ssCcfAvgDet_0_y2_or;
  assign ssCcfAvgDet_0_y2_ff       = yCor2_ff;

  assign yCor3                     = ssCcfAvgDet_0_y3;
  assign yCor3_or                  = ssCcfAvgDet_0_y3_or;
  assign ssCcfAvgDet_0_y3_ff       = yCor3_ff;

  assign yCor4                     = ssCcfAvgDet_0_y4;
  assign yCor4_or                  = ssCcfAvgDet_0_y4_or;
  assign ssCcfAvgDet_0_y4_ff       = yCor4_ff;

  assign yAbs                      = ctfe_0_yAbs;
  assign yAbs_or                   = ctfe_0_yAbs_or;
  assign ctfe_0_yAbs_ff            = yAbs_ff;

  assign yPh                       = ctfe_0_yPh;
  assign yPh_or                    = ctfe_0_yPh_or;
  assign ctfe_0_yPh_ff             = yPh_ff;


  // --------------------------------------------------------------------------------------
  // Define register control output
  assign regWeOut = 0 | ssNorm_0_regWe | ssCcf_0_regWe | ssCcfAbs_0_regWe
                      | ssCcfAvgDet_0_regWe | ctfe_0_regWe | s1To2And_10_regWe
                      | buf2_9_regWe;
  assign regReOut = 0 | ssNorm_0_regRe | ssCcf_0_regRe | ssCcfAbs_0_regRe
                      | ssCcfAvgDet_0_regRe | ctfe_0_regRe | s1To2And_10_regRe
                      | buf2_9_regRe;

// ----------------------------------------------------------------------------------------
//=========================================================================================

  // --------------------------------------------------------------------------------------
  // Definitions
  wire  waitEnd;
  wire  yCorThrExcd;
  
  // --------------------------------------------------------------------------------------
  // Connect run signals
  assign  ssNorm_0_run1      = run1;
  assign  ssCcf_0_run1       = run1;
  assign  ssCcfAbs_0_run1    = run1;
  assign  ssCcfAvgDet_0_run1 = run1;
  assign  ctfe_0_run1        = run1;
  
  // Connect output interrupts + state transition conditions
  assign  yCorThrExcd = ssCcfAvgDet_0_y2[yCor2_w-1]==0 ||  // Threshold is exceeded 
                        ssCcfAvgDet_0_y3[yCor3_w-1]==0 ||  // if any of the outputs
                        ssCcfAvgDet_0_y4[yCor4_w-1]==0;    // is positive
  assign  irqSsDet = stateAcq==StWaitAvgDet       & yCor2_or & yCorThrExcd;
  assign  waitEnd  = stateAcq==StWait             & yAbs_or  & waitCnt==waitSmpl;
  assign  irqSsEnd = stateAcq==StWaitPreambleEnd  & yAbs_or  & yAbs[yAbs_w-1]==1 
                     & ssAcqHalt==0;
    
  // Connect estimation outputs to EREG internal input
  assign  ampEst_d      = buf2_9_y;
  assign  ampEst_weint  = irqSsEnd;
  assign  freqOff_d     = yPhD[2];
  assign  freqOff_weint = irqSsEnd;
  assign  timeOff_d     = ctfeCnt;
  assign  timeOff_weint = irqSsEnd;
  
  // --------------------------------------------------------------------------------------
  // Main FSM
  always @(posedge clk) begin
    
    // Reset
    if (run1==0) begin
      ctfeCnt       <= 0;
      ssCorCnt      <= 0;
      waitCnt       <= 0;
      stateAcq      <= StWaitAvgDet;
      yPhD[0]       <= 0;
      yPhD[1]       <= 0;
      yPhD[2]       <= 0;

    // Normal operation
    end else begin
      
      // Output sample counters
      if (yCor2_or & stateAcq==StWaitAvgDet & irqSsDet==0) begin
        ssCorCnt <= ssCorCnt+2;
      end
      if (yAbs_or) begin
        ctfeCnt <= ctfeCnt+1;
      end

      // Wait state counter 
      //  - start synchronized after ssCor detetection
      //  - count up until waitEnd condition is hit
      if (stateAcq==StWait & yAbs_or & 
         ((waitCnt==0 & ssCorCnt[7:5]==ctfeCnt[2:0]) | waitCnt!=0)) begin
        waitCnt <= waitCnt+1;
      end
      
      if (yPh_or) begin
        yPhD[0] <= ctfe_0_yPh;
        yPhD[1] <= yPhD[0];
        yPhD[2] <= yPhD[1];
      end
            
      // Wait for SS detection, i.e. output ssCcfAvgDet_0_y>=0
      if (irqSsDet) begin
        stateAcq <= StWait;
      end else
      
      // Wait a few samples after the end of SS detection
      if (waitEnd) begin
        stateAcq <= StWaitPreambleEnd;
      end else
      
      // Wait for end of preamble, i.e., ctfe_0_yAbs<0
      if (irqSsEnd) begin
        stateAcq <= StAcqDone;
      end
      
    end // if (run1==0) ... else
  end // always

  // --------------------------------------------------------------------------------------
  // Manual connections of submodule control
  assign  ssNorm_0_run1      = run1;
  assign  ssCcf_0_run1       = run1;
  assign  ssCcfAbs_0_run1    = run1;
  assign  ssCcfAvgDet_0_run1 = run1;
  assign  ctfe_0_run1        = run1;
  assign  buf2_9_run1        = run1;

  // Synchronize output buffer of ssNorm amplitude to CTFE
  assign  buf2_9_y_ff = ~(yAbs_or & ctfeCnt[0]==1);

endmodule
//=========================================================================================

