//==============================================================================
//  Copyright (C) BAY9, 2007
//==============================================================================
//
// NAME:
//   resetCnt
//
// PURPOSE:
//   Create long reset pulse
//
// INPUT:
//   resetIn:   Reset input pulse
//
// OUTPUT:
//   resetOut:  Reset output pulse
//
// DESCRIPTION:
//   Upon a short pulse at resetIn, start counting until
//   0b1000...000 is reached and issue resetOut while counting.
//   The number was chosen to provide a reset also upon loading
//   the circuit, assuming an arbitrary number or 0 in the count
//   register. 
//
// HISTORY:
//   01-Jan-07, Dirk Sommer
//     Initial version
//
//==============================================================================

//==============================================================================
module resetCnt(resetOut, resetIn, clk);

  // Parameter
  parameter w = 8;

  // Define inputs and outputs
  output            resetOut;
  input             resetIn;
  input             clk;

  // Define counter
  reg     [w-1:0]   cnt;
  wire              cntUp;
  reg               resetOutR;

  // Count up until counter is binary 1000....0000
  assign cntUp  = cnt != {1'b1, {w-1{1'b0}}};
  
  // Counter operation
  always @(posedge clk) begin
    if (resetIn)
      cnt <= 0;
    else if (cntUp) 
      cnt <= cnt+1;
    resetOutR <= cntUp;     // Issue reset signal until 0b100...000 is reached
  end    

  // Assign registered output
  assign resetOut = resetOutR;
  
endmodule
//==============================================================================

