//==============================================================================
//  Copyright (C) Dirk Sommer, 2006
//==============================================================================
//
//  NAME:
//    mulSi
//
//  PURPOSE:
//    Multiplication of 2 integers
//
//  DESCRIPTION:
//    Multply 2 integers,
//      c = a*b, 
//    the sign of the input depends on the parameters
//
//  PARAMETERS:
//    c_w    = width of output c
//    a_w    = width of input a
//    b_w    = width of input b
//    
//  INPUTS:
//    a     =  1. multiplier input
//    b     =  2. muliplier input
//  
//  OUTPUTS:
//    c     = multiplier output
//
//  HISTORY:
//    17-Dec-2006, Sommer:
//      Initial version, derived from mul.v
//
//==============================================================================

//==============================================================================
module mulSi(c, a, b);

  // Module parameters
  parameter c_w          = 15;
  parameter a_w          = 8;
  parameter b_w          = 8;

  // Ports
  output    [c_w-1:0]    c;
  input     [a_w-1:0]    a;
  input     [b_w-1:0]    b;

  // Internal declarations
   wire     [2*c_w:0]  cx;
   wire     [c_w:0]    a1, b1;
   wire                as, bs;

  // ---------------------------------------------------------------------------
  // Operation

  // Get sign extension bit
  assign as = a[a_w-1];
  assign bs = b[b_w-1];

  // Extend signed bit, simply use large extension (don't care)
  assign a1 = { {c_w-a_w{as}} , a[a_w-1:0]};
  assign b1 = { {c_w-b_w{bs}} , b[b_w-1:0]};

  // Multiply
  assign cx = a1*b1;
  assign c  = cx[c_w-1:0];

endmodule
//==============================================================================
