//=========================================================================================
//  Copyright (C) BAY9, 2011
//=========================================================================================
//
//  NAME:
//    fifoA
//
//  PURPOSE:
//    FIFO - like FIFO-B (-> detailed description), but include reset via regBus
//
//  HISTORY:
//    29-Jan-2011, Dirk Sommer
//      Change to include FIFO-B
//
// ========================================================================================
module fifoA(q, fe, ff, ff2, fuf, fof, d, re, we, ird, ord, regBus, regWe, clk);

  // Define parameters - typically overwritten from outside
  parameter m = 10;                     // Address width 
  parameter n = 1024;                   // Number of elements
  parameter w = 16;                     // Data width
  parameter a = 0;                      // FIFO address

  // Define inputs and outputs
  output  [w-1:0] q;                    // Data output
  output          fe;                   // Fifo empty
  output          ff;                   // Fifo full
  output          ff2;                  // Fifo full, but only when re=0
  output          fuf;                  // Fifo underflow
  output          fof;                  // Fifo overflow

  input   [w-1:0] d;                    // Data input
  input           re;                   // Read enable
  input           we;                   // Write enable
  input           ird;                  // Input ready
  input           ord;                  // Output ready
  input    [15:0] regBus;               // Register bus
  input           regWe;                // Register write enable
  input           clk;                  // Clock
  
  // Simply include FIFO-B, but provide reset via register bus
  wire rst;
  assign rst = regBus==a & regWe;
  
  fifoB fifoB_0(q, fe, ff, ff2, fuf, fof, d, re, we, ird, ord, rst, clk);
  defparam fifoB_0.m = m;
  defparam fifoB_0.n = n;
  defparam fifoB_0.w = w;
  defparam fifoB_0.a = a;

endmodule
//========================================================================================
        
