//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter wdfCore_0_x_w             = 14;
  parameter wdfCore_0_c_w             = 12;
  parameter wdfCore_0_selA_w          = 1;
  parameter wdfCore_0_selB_w          = 2;
  parameter wdfCore_0_selS_w          = 2;

  // Outputs
  parameter wdfCore_0_y_w             = 14;

  // Input control lines
  parameter wdfCore_0_run1_w          = 2;

  // Output control lines

  // Eregs

  // Parameters
  parameter wdfCore_0_w               = 14;
  parameter wdfCore_0_wc              = 12;

  // Iregs
  parameter wdfCore_0_B_w             = 14;
  parameter wdfCore_0_B_n             = 4;
  parameter wdfCore_0_B_m             = `CLOG2(4);
  parameter wdfCore_0_R_w             = 14;
  parameter wdfCore_0_R_n             = 1;
  parameter wdfCore_0_R_m             = `CLOG2(1);
  parameter wdfCore_0_S_w             = 14;
  parameter wdfCore_0_S_n             = 1;
  parameter wdfCore_0_S_m             = `CLOG2(1);

  // Single ported memories

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam wdfCore_0.x_w             = wdfCore_0_x_w;
  defparam wdfCore_0.c_w             = wdfCore_0_c_w;
  defparam wdfCore_0.selA_w          = wdfCore_0_selA_w;
  defparam wdfCore_0.selB_w          = wdfCore_0_selB_w;
  defparam wdfCore_0.selS_w          = wdfCore_0_selS_w;
  defparam wdfCore_0.y_w             = wdfCore_0_y_w;
  defparam wdfCore_0.run1_w          = wdfCore_0_run1_w;
  defparam wdfCore_0.w               = wdfCore_0_w;
  defparam wdfCore_0.wc              = wdfCore_0_wc;
  defparam wdfCore_0.B_w             = wdfCore_0_B_w;
  defparam wdfCore_0.B_n             = wdfCore_0_B_n;
  defparam wdfCore_0.B_m             = wdfCore_0_B_m;
  defparam wdfCore_0.R_w             = wdfCore_0_R_w;
  defparam wdfCore_0.R_n             = wdfCore_0_R_n;
  defparam wdfCore_0.R_m             = wdfCore_0_R_m;
  defparam wdfCore_0.S_w             = wdfCore_0_S_w;
  defparam wdfCore_0.S_n             = wdfCore_0_S_n;
  defparam wdfCore_0.S_m             = wdfCore_0_S_m;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire                 [wdfCore_0_y_w-1:0]  wdfCore_0_y;
  wire                                      wdfCore_0_y_or;
  wire                                      wdfCore_0_y_ff;
  wire                                      wdfCore_0_y_we;

  wire               [wdfCore_0_x_w-1:0]  wdfCore_0_x;
  wire                                      wdfCore_0_x_ir;
  wire                                      wdfCore_0_x_fe;
  wire                                      wdfCore_0_x_re;

  wire                 [wdfCore_0_c_w-1:0]  wdfCore_0_c;
  wire                                      wdfCore_0_c_ir;
  wire                                      wdfCore_0_c_fe;
  wire                                      wdfCore_0_c_re;

  wire              [wdfCore_0_selA_w-1:0]  wdfCore_0_selA;
  wire                                      wdfCore_0_selA_ir;
  wire                                      wdfCore_0_selA_fe;
  wire                                      wdfCore_0_selA_re;

  wire              [wdfCore_0_selB_w-1:0]  wdfCore_0_selB;
  wire                                      wdfCore_0_selB_ir;
  wire                                      wdfCore_0_selB_fe;
  wire                                      wdfCore_0_selB_re;

  wire              [wdfCore_0_selS_w-1:0]  wdfCore_0_selS;
  wire                                      wdfCore_0_selS_ir;
  wire                                      wdfCore_0_selS_fe;
  wire                                      wdfCore_0_selS_re;

  wire              [wdfCore_0_run1_w-1:0]  wdfCore_0_run1;

  wire                                      wdfCore_0_regWe;
  wire                                      wdfCore_0_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  wdfCore wdfCore_0(wdfCore_0_y, wdfCore_0_y_or, wdfCore_0_y_ff, wdfCore_0_y_we,
                      wdfCore_0_x, wdfCore_0_x_ir, wdfCore_0_x_fe, wdfCore_0_x_re, 
                      wdfCore_0_c, wdfCore_0_c_ir, wdfCore_0_c_fe, wdfCore_0_c_re, 
                      wdfCore_0_selA, wdfCore_0_selA_ir, wdfCore_0_selA_fe, wdfCore_0_selA_re, 
                      wdfCore_0_selB, wdfCore_0_selB_ir, wdfCore_0_selB_fe, wdfCore_0_selB_re, 
                      wdfCore_0_selS, wdfCore_0_selS_ir, wdfCore_0_selS_fe, wdfCore_0_selS_re, 
                      wdfCore_0_run1, 
                      regBus, regWe, regRe, wdfCore_0_regWe, wdfCore_0_regRe, clk, clk2, reset);


//==============================================================================
