//====================================================================================
//  Copyright (C) BAY9, 2015
//====================================================================================
//
// MODULE:
//   tx11aTest
//
// PURPOSE:
//   Test module for TX 802.11a including the FFT
//
// INPUT:
//   x:       Input bytes
//
// OUTPUT:
//   y:       Complex output samples
//
// PARAMETER:
//   w:       Output data bit width
//
// DESCRIPTION:
//   Schematic:
//                                         
//           .....................         
//           :                   :         
//        y  :     ||     :  x      
//      <----------| tx11a |<----------    
//           :     |_______|     :         
//           :       ^   |       :         
//           :.......|...|.......:         
//                   |   |                 
//               yFft|   |xFft             
//               .---   `----.            
//               |            |            
//               | ||  |            
//               `-| fft64 |<-            
//                 |_______|               
//
// HISTORY:
//   11-Jan-11, Dirk Sommer
//     Initial version
//
//====================================================================================

module tx11aTest(y, y_or, y_ff, y_we, 
                 x, x_ir, x_fe, x_re, 
                 regBus, regWe, regRe, regWeOut, regReOut, clk1, clk2, reset);

  // --------------------------------------------------------------------------------------
  // Module parameters
  parameter y_w               = 0;
  parameter x_w               = 0;


  parameter w                 = 0;

  // --------------------------------------------------------------------------------------
  // Inputs and outputs
  output            [y_w-1:0]  y;
  output                       y_or;
  input                        y_ff;
  output                       y_we;
  assign                       y_we = y_or & ~y_ff;

  input             [x_w-1:0]  x;
  output                       x_ir;
  input                        x_fe;
  output                       x_re;
  assign                       x_re = x_ir & ~x_fe;


  // Define clock and reset
  input                        clk1;
  input                        clk2;
  input                        reset;

  // Inputs and outputs for registers
  inout                [15:0]  regBus;
  input                        regWe;
  input                        regRe;
  output                       regWeOut;
  output                       regReOut;

  // Assign clock
  wire clk;
  assign clk = clk1;

  // --------------------------------------------------------------------------------------
  // External status registers
  // --------------------------------------------------------------------------------------
  // Included instances
  `include "tx11a_0.v"
  `include "fft64_0.v"

  // --------------------------------------------------------------------------------------
  // Define connections
  assign tx11a_0_x                 = x;
  assign tx11a_0_x_fe              = x_fe;
  assign x_ir                      = tx11a_0_x_ir;

  assign fft64_0_x                 = tx11a_0_yFft;
  assign fft64_0_x_fe              = ~tx11a_0_yFft_or;
  assign tx11a_0_yFft_ff           = ~fft64_0_x_ir;

  assign tx11a_0_xFft              = fft64_0_y;
  assign tx11a_0_xFft_fe           = ~fft64_0_y_or;
  assign fft64_0_y_ff              = ~tx11a_0_xFft_ir;

  assign y                         = tx11a_0_y;
  assign y_or                      = tx11a_0_y_or;
  assign tx11a_0_y_ff              = y_ff;


  // --------------------------------------------------------------------------------------
  // Define register control output
  assign regWeOut = 0 | tx11a_0_regWe | fft64_0_regWe;
  assign regReOut = 0 | tx11a_0_regRe | fft64_0_regRe;

// ----------------------------------------------------------------------------------------

//=========================================================================================
// Autogenerate end - do not remove this comment
//=========================================================================================

endmodule
//=========================================================================================

