//==============================================================================
//  Copyright (C) BAY9, 2015
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter normXDivCore_0_nIn_w           = 11;
  parameter normXDivCore_0_qIn_w           = 9;
  parameter normXDivCore_0_dIn_w           = 8;

  // Outputs
  parameter normXDivCore_0_nOut_w          = 11;
  parameter normXDivCore_0_qOut_w          = 9;

  // Input control lines

  // Output control lines

  // Eregs

  // Parameters
  parameter normXDivCore_0_wn              = 11;
  parameter normXDivCore_0_wd              = 8;
  parameter normXDivCore_0_wq              = 9;
  parameter normXDivCore_0_ws              = 2;
  parameter normXDivCore_0_wy              = 10;

  // Iregs

  // Single ported memories

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam normXDivCore_0.nIn_w           = normXDivCore_0_nIn_w;
  defparam normXDivCore_0.qIn_w           = normXDivCore_0_qIn_w;
  defparam normXDivCore_0.dIn_w           = normXDivCore_0_dIn_w;
  defparam normXDivCore_0.nOut_w          = normXDivCore_0_nOut_w;
  defparam normXDivCore_0.qOut_w          = normXDivCore_0_qOut_w;
  defparam normXDivCore_0.wn              = normXDivCore_0_wn;
  defparam normXDivCore_0.wd              = normXDivCore_0_wd;
  defparam normXDivCore_0.wq              = normXDivCore_0_wq;
  defparam normXDivCore_0.ws              = normXDivCore_0_ws;
  defparam normXDivCore_0.wy              = normXDivCore_0_wy;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire         [normXDivCore_0_nOut_w-1:0]  normXDivCore_0_nOut;
  wire                                      normXDivCore_0_nOut_or;
  wire                                      normXDivCore_0_nOut_ff;
  wire                                      normXDivCore_0_nOut_we;

  wire         [normXDivCore_0_qOut_w-1:0]  normXDivCore_0_qOut;
  wire                                      normXDivCore_0_qOut_or;
  wire                                      normXDivCore_0_qOut_ff;
  wire                                      normXDivCore_0_qOut_we;

  wire          [normXDivCore_0_nIn_w-1:0]  normXDivCore_0_nIn;
  wire                                      normXDivCore_0_nIn_ir;
  wire                                      normXDivCore_0_nIn_fe;
  wire                                      normXDivCore_0_nIn_re;

  wire          [normXDivCore_0_qIn_w-1:0]  normXDivCore_0_qIn;
  wire                                      normXDivCore_0_qIn_ir;
  wire                                      normXDivCore_0_qIn_fe;
  wire                                      normXDivCore_0_qIn_re;

  wire          [normXDivCore_0_dIn_w-1:0]  normXDivCore_0_dIn;
  wire                                      normXDivCore_0_dIn_ir;
  wire                                      normXDivCore_0_dIn_fe;
  wire                                      normXDivCore_0_dIn_re;

  wire                                      normXDivCore_0_regWe;
  wire                                      normXDivCore_0_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  normXDivCore normXDivCore_0(normXDivCore_0_nOut, normXDivCore_0_nOut_or, normXDivCore_0_nOut_ff, normXDivCore_0_nOut_we,
                              normXDivCore_0_qOut, normXDivCore_0_qOut_or, normXDivCore_0_qOut_ff, normXDivCore_0_qOut_we,
                              normXDivCore_0_nIn, normXDivCore_0_nIn_ir, normXDivCore_0_nIn_fe, normXDivCore_0_nIn_re, 
                              normXDivCore_0_qIn, normXDivCore_0_qIn_ir, normXDivCore_0_qIn_fe, normXDivCore_0_qIn_re, 
                              normXDivCore_0_dIn, normXDivCore_0_dIn_ir, normXDivCore_0_dIn_fe, normXDivCore_0_dIn_re, 
                              regBus, regWe, regRe, normXDivCore_0_regWe, normXDivCore_0_regRe, clk, clk2, reset);


//==============================================================================
