function cfm = msgWlanRxStartCfm(id)
%===============================================================================
%  Copyright (C) BAY9, 2014
%===============================================================================
%
% Syntax:
%   cfm = msgWlanRxStartCfm(id)
%
% Inputs:
%   id    - Target identifier
%
% Outputs:
%   cfm   - MsgIdWlan.RxStartCfm
%
% Description:
%   Read the RxStartCfm.
%
%===============================================================================

  % ----------------------------------------------------------------------------
  % Global definitions
  global MsgIdWlan;

  % Define message core
  id.core = 'wlan';
      
  % ----------------------------------------------------------------------------
  % Wait for RX sync or acquisition stop
  cfm = sendMsg(id, [], 1);
    
  % Debug: check confirm
  if (cfm(1) ~= MsgIdWlan.RxStartCfm)
    fprintf('Error reading RX start confirm\n');
    pause
  end
  
% ------------------------------------------------------------------------------

  
  
