function cfm = msgWlanRxEndCfm(id)
%===============================================================================
%  Copyright (C) BAY9, 2014
%===============================================================================
%
% Syntax:
%   cfm = msgWlanRxEndCfm(id)
%
% Inputs:
%   id    - Target identifier
%
% Outputs:
%   cfm   - [MsgIdWlan.RxEndCfm CRC]
%
% Description:
%   Read the RxEndCfm and the CRC.
%
%===============================================================================

  % ----------------------------------------------------------------------------
  % Global definitions
  global MsgIdWlan;

  % Define message core
  id.core = 'wlan';
      
  % ----------------------------------------------------------------------------
  % Wait for RX sync or acquisition stop
  cfm = sendMsg(id, [], 2);
    
  % Debug: check confirm
  if (cfm(1) ~= MsgIdWlan.RxEndCfm)
    fprintf('Error reading RX end confirm\n');
    pause
  end
  
% ------------------------------------------------------------------------------

  
  
