function msgWlanResetReq(id)
%===============================================================================
%  Copyright (C) BAY9, 2011
%===============================================================================
%
% Syntax:
%   msgWlanResetReq(id)
%
% Inputs:
%   id        - Target identifier
%
% Outputs:
%   --
%
% Description:
%   Send the reset message. Different from other message, there is no
%   confirm message. Instead, there is a boot confirm sent after reboot. 
%
%===============================================================================

  % ----------------------------------------------------------------------------
  % Global defintions
  global MsgIdWlan;
  
  % Define message core
  id.core = 'wlan';
      
  % ----------------------------------------------------------------------------
  % Reset the system
  req   = MsgIdWlan.ResetReq;
  nCfm  = 0;
  sendMsg(id, req, nCfm);
  pause(0.2);
  
%===============================================================================
