function cfm = msgWlanLedBlinkReq(id, blinkPeriod)
%===============================================================================
%  Copyright (C) BAY9, 2014
%===============================================================================
%
% Syntax:
%   cfm = msgWlanLedBlinkReq(id)
%
% Inputs:
%   id          - Target identifier
%   blinkPeriod - LED blinking period in 2^20 cycles, 1..1000, default 5
%
% Outputs:
%   cfm       - MsgId.LedBlinkCfm
%
% Description:
%   Let the LEDs blink for a moment
%
%===============================================================================

  % ----------------------------------------------------------------------------
  % Global defintions
  global MsgIdWlan;
  
  % Define message core
  id.core = 'wlan';
    
  % Default blink period = 5*2^20 cycles
  if (nargin == 1)
    blinkPeriod = 5;
  end
    
  % ----------------------------------------------------------------------------
  % Send message
  req   = [MsgIdWlan.LedBlinkReq, blinkPeriod];
  nCfm  = 1;
  cfm   = sendMsg(id, req, nCfm);
  
  % Debug: check confirm
  if (cfm(1) ~= MsgIdWlan.LedBlinkCfm)
    fprintf('Error sending TB LED blink request\n');
    pause
  end

%===============================================================================
