function [dat cfm] = msgWlanIqBufReadReq(id, nSmpl)
%===============================================================================
%  Copyright (C) BAY9, 2016
%===============================================================================
%
% Syntax:
%   [dat cfm] = msgWlanIqBufReadReq(id, dat)
%
% Inputs:
%   id          - Target identifier
%   nSmpl       - Number of samples to return
%
% Outputs:
%   dat         - Complex valued 12 bit integer data
%   cfm         - MsgIdWlan.IqBufReadCfm
%
% Description:
%   Read data from the IQ sample buffer, send msg
%
%     req = [MsgIdWlan.IqBufReadReq, nSampl]
%   
%   The complex output is generated from a 24 bit unsigned integer, 
%   which is returned split into 16 bit lower, and 8 bit higher part
%   in the confirm message, i.e. [dat0Lo, dat0Hi, dat1Lo, ...].
%
%===============================================================================

  % ----------------------------------------------------------------------------
  % Global defintions
  global MsgIdWlan;

  % Define message core
  id.core = 'wlan';
    
  % ----------------------------------------------------------------------------
  % Send message
  req   = [MsgIdWlan.IqBufReadReq, nSmpl];
  nCfm  = 1 + nSmpl*2;
  cfm   = sendMsg(id, req, nCfm);
  
  % Debug: check confirm
  if (cfm(1) ~= MsgIdWlan.IqBufReadCfm)
    fprintf('Error sending IqBufRead request\n');
    pause
  end

  % Reformat output data
  datLo   = cfm(2:2:end);               % 16 lower bits
  datHi   = cfm(3:2:end);               % 8 upper bits
  datLoHi = datLo + 2^16*datHi;         % 24 bits
  datRe   = mod(datLoHi, 2^12);         % Real part
  datRe   = datRe - (datRe>=2^11)*2^12;
  datIm   = floor(datLoHi/2^12);        % Imag part
  datIm   = datIm - (datIm>=2^11)*2^12;
  dat     = datRe + j*datIm;            % Complex valued output
  
%===============================================================================
