function [cfm dat] = msgWlanGetGpiReq(id, mask)
%===============================================================================
%  Copyright (C) BAY9, 2011
%===============================================================================
%
% Syntax:
%   cfm = msgWlanGetGpiReq(id, mask)
%
% Inputs:
%   id          - Target identifier
%   mask        - Mask bits
%
% Outputs:
%   cfm         - MsgIdWlan.GetGpiCfm + input data (masked)
%   dat         - Input data only (masked)
%
% Description:
%   Send the get GPI request message
%
%     req = [MsgIdWlan.GetGpiReq, mask]
%
%   and read the input data value. The output corresponds to the input
%   data bits when the corresponding masks bits are set, all other bits
%   are zero.
%
%===============================================================================

  % ----------------------------------------------------------------------------
  % Global defintions
  global MsgIdWlan;

  % Define message core
  id.core = 'wlan';
      
  % ----------------------------------------------------------------------------
  % Send message
  req   = [MsgIdWlan.GetGpiReq, mask];
  nCfm  = 2;
  cfm   = sendMsg(id, req, nCfm);
  
  % Debug: check confirm
  if (cfm(1) ~= MsgIdWlan.GetGpiCfm)
    fprintf('Error sending get GPI request\n');
    pause
  end

  % Get data only
  dat = cfm(2);

%===============================================================================
