function cfm = msgWlanCfgTxTimingReq(id, paDelay, txDelay, bbDelay)
%===============================================================================
%  Copyright (C) BAY9, 2011
%===============================================================================
%
% Syntax:
%   cfm = msgWlanCfgTxTimingReq(id, paDelay, txDelay, bbDelay)
%
% Inputs:
%   id          - Target identifier
%   paDelay     - RF-PA switch on delay in timer ticks
%   txDelay     - RF-TX switch on delay in timer ticks
%   bbDelay     - Baseband start delay in timer ticks
%
% Outputs:
%   cfm         - MsgIdWlan.CfgTxTimingCfm
%
% Description:
%   Send config TX timing message, format:
%
%     req = [MsgIdWlan.CfgTxTimingReq, paDelay, txDelay, bbDelay]
%
%   and set the corresponding registers in the txRfCtrl module. All values
%   must be between 1..65535.
%
%===============================================================================

  % ----------------------------------------------------------------------------
  % Global defintions
  global MsgIdWlan;
    
  % Define message core
  id.core = 'wlan';
    
  % ----------------------------------------------------------------------------
  % Send message
  req   = [MsgIdWlan.CfgTxTimingReq, paDelay, txDelay, bbDelay];
  nCfm  = 1;
  cfm   = sendMsg(id, req, nCfm);
  
  % Debug: check confirm
  if (cfm(1) ~= MsgIdWlan.CfgTxTimingCfm)
    fprintf('Error sending TX timing request\n');
    pause
  end

%===============================================================================
