function cfm = msgWlanCfgTxDataSrcReq(id, dataSrc, numBytes, startValue)
%===============================================================================
%  Copyright (C) BAY9, 2011
%===============================================================================
%
% Syntax:
%   cfm = msgWlanCfgTxDataSrcReq(id, dataSrc, numBytes, startValue)
%
% Inputs:
%   id          - Target identifier
%   dataSrc     - 0=external, 1=internal
%   numBytes    - Number of bytes to transmit for internal datageneration
%   startValue  - 0..255, internal data start value
%
% Outputs:
%   cfm         - MsgIdWlan.CfgTxDataSrcCfm
%
% Description:
%   Configure the TX data source. If the first value is 0, the data is assumed
%   to be provided by the external port bIn (normal operation). For testing,
%   data can be generated internally, counting up numBytes starting with
%   startValue. In this case, the message must be sent before each TX request.
%
%===============================================================================

  % ----------------------------------------------------------------------------
  % Global defintions
  global MsgIdWlan;
    
  % Define message core
  id.core = 'wlan';
    
  % ----------------------------------------------------------------------------
  % Send message
  req   = [MsgIdWlan.CfgTxDataSrcReq, dataSrc, numBytes, startValue];
  nCfm  = 1;
  cfm   = sendMsg(id, req, nCfm);
  
  % Debug: check confirm
  if (cfm(1) ~= MsgIdWlan.CfgTxDataSrcCfm)
    fprintf('Error sending TX data src config request\n');
    pause
  end

%===============================================================================
