function cfm = msgWlanCfgTtReq(id, fc, fSc, ttRev)
%===============================================================================
%  Copyright (C) BAY9, 2011
%===============================================================================
%
% Syntax:
%   cfm = msgWlanCfgTtReq(id, fc, fSc, bandRev)
%
% Inputs:
%   id          - Target identifier
%   fc          - Carrier frequency in Hz
%   fSc         - Subcarrier spacing in Hz
%   ttRev       - Band reversal off/on (0/1)
%
% Outputs:
%   cfm         - MsgIdWlan.CfgTtCfm
%
% Description:
%   Calculate time tracking parameters TT mantissa, TT shift, and TT jump
%   as (see code for details), and send to SS-11a subsystem via message.
%
%   Set fc=0 for baseband transmission, this sets the parameters such that
%   time tracking is effectively switched off.
%
%   Note that the time tracking reversal parameter needs to be set to 1 if and
%   only if the signal is really transmitted band reversed over the air. This
%   is typically not the case, even if the band reversal parameter is set in
%   the band selection message where it normally only compensates for another
%   band reversal caused by the RF. Therefore, the band reversal parameter in
%   this message is normally 0.
%
%===============================================================================

  % ----------------------------------------------------------------------------
  % Global defintions
  global MsgIdWlan;
    
  % Define message core
  id.core = 'wlan';
    
  % ----------------------------------------------------------------------------
  % Calculate TT parameters
  if (fc ~= 0)
    ttExp     = floor(log2(fSc/fc))+18;
    ttShift   = 2^ttExp;
    ttMant    = floor((fSc/fc)/2^(ttExp-32)) * (-1)^ttRev;
    ttJump    = round(fc/(64*fSc)*2^16)      * (-1)^ttRev;
    ttJumpLo  = mod(ttJump, 2^16);
    ttJumpHi  = floor(ttJump/2^16);
  else
    ttShift   = 0;
    ttMant    = 0;
    ttJumpLo  = 0;
    ttJumpHi  = 0;
  end
  
  % ----------------------------------------------------------------------------
  % Send message
  req   = [MsgIdWlan.CfgTtReq, ttMant, ttShift, ttJumpLo, ttJumpHi];
  nCfm  = 1;
  cfm   = sendMsg(id, req, nCfm);
  
  % Debug: check confirm
  if (cfm(1) ~= MsgIdWlan.CfgTtCfm)
    fprintf('Error sending time tracking config request\n');
    pause
  end

%===============================================================================
