function [cfm time32] = msgWlanCfgTimerPrescaleReq(id, p, q)
%===============================================================================
%  Copyright (C) BAY9, 2013
%===============================================================================
%
% Syntax:
%   cfm = msgWlanCfgTimerPrescaleReq(id, p, q)
%
% Inputs:
%   id          - Target identifier
%   p           - Prescaler numerator
%   q           - Prescaler denominator
%
% Outputs:
%   cfm         - MsgIdWlan.CfgTimerPrescaleCfm
%
% Description:
%   Set the timer prescaler. The timer counts with frequency p/q * FpgaClk.
%   Factors p and q must be chosen such that the timer effectively counts
%   with the baseband sample frequency (20 MHz). For proper operation, p<=q
%   must hold.
%
%===============================================================================

  % ----------------------------------------------------------------------------
  % Global defintions
  global MsgIdWlan;

  % Define message core
  id.core = 'wlan';
  
  % ----------------------------------------------------------------------------
  % Get factors
  if (p <= 0 || p >= 2^32-1)
    p
    error('Factor p out of range');
  end
  if (q <= 0 || q >= 2^32-1 || q < p)
    p, q
    error('Factor q out of range');
  end
  
  pLo = mod(p, 2^16);
  pHi = floor(p/2^16);
  qLo = mod(q, 2^16);
  qHi = floor(q/2^16);
  
  % Send message
  req   = [MsgIdWlan.CfgTimerPrescaleReq, pLo, pHi, qLo, qHi];
  nCfm  = 1;
  cfm   = sendMsg(id, req, nCfm);

  % Debug: check confirm
  if (cfm(1) ~= MsgIdWlan.CfgTimerPrescaleCfm)
    fprintf('Error sending MsgCfgTimerPrescaleReq\n');
    pause;
  end
  
%===============================================================================

