function cfm = msgWlanCfgDcOffCorrRxReq(id, rxDcOff)
%===============================================================================
%  Copyright (C) BAY9, 2016
%===============================================================================
%
% Syntax:
%   cfm = msgWlanCfgDcOffCorrRxReq(id, rxDcOff)
%
% Inputs:
%   id          - Target identifier
%   rxDcOff     - Vector 1x70, complex valued, range [-2^11, 2^11-1]
%
% Outputs:
%   cfm         - MsgIdWlan.CfgDcOffCorrRxCfm
%
% Description:
%   Send config RX DC offset table message, format:
%
%     msg = [MsgIdWlan.CfgDcOffCorrRxReq, dcOffRe(0), dcOffIm(0), dcOffRe(1),...]
%
%   for all possible 70 AGC steps, starting with the lowest attenuation.
%
%===============================================================================

  % ----------------------------------------------------------------------------
  % Global definitions
  global MsgIdWlan;
    
  % Define message core
  id.core = 'wlan';
    
  % ----------------------------------------------------------------------------
  % Combine input to table settings
  rxDcOffTable  = [real(rxDcOff); imag(rxDcOff)];
  rxDcOffTable  = rxDcOffTable(:)';
  
  % Send message
  req   = [MsgIdWlan.CfgDcOffCorrRxReq, rxDcOffTable];
  nCfm  = 1;
  cfm   = sendMsg(id, req, nCfm);
  
  % Debug: check confirm
  if (cfm(1) ~= MsgIdWlan.CfgDcOffCorrRxCfm)
    fprintf('Error sending RX DC offset table config request\n');
    pause
  end

%===============================================================================
