function cfm = msgWlanCfgDcOffCorrReq(id, offOn)
%===============================================================================
%  Copyright (C) BAY9, 2016
%===============================================================================
%
% Syntax:
%   cfm = msgWlanCfgDcOffCorrReq(id, offOn)
%
% Inputs:
%   id        - Target identifier
%   offOn     - 0/1 switches DC offset correction off/on
%
% Outputs:
%   cfm       - MsgIdWlan.CfgDcOffCorrCfm
%
% Description:
%   Send config RX DC offset message, format:
%
%     msg = [MsgIdWlan.CfgDcOffCorrReq, offOn]
%
%   in order to switch AGC dependent RX-DC offset compensation and fixed TX-DC
%   offset correction in baseband on or off.
%
%===============================================================================

  % ----------------------------------------------------------------------------
  % Global defintions
  global MsgIdWlan;
    
  % Define message core
  id.core = 'wlan';
    
  % ----------------------------------------------------------------------------
  % Send message
  req   = [MsgIdWlan.CfgDcOffCorrReq, offOn];
  nCfm  = 1;
  cfm   = sendMsg(id, req, nCfm);
  
  % Debug: check confirm
  if (cfm(1) ~= MsgIdWlan.CfgDcOffCorrCfm)
    fprintf('Error sending RX DC offset config request\n');
    pause
  end

%===============================================================================
