function cfm = msgWlanCfgBandSelReq(id, ifSel, bandRev, singleAdc)
%===============================================================================
%  Copyright (C) BAY9, 2011
%===============================================================================
%
% Syntax:
%   cfm = msgWlanCfgBandSelReq(id, ifSel, bandRev, singleAdc)
%
% Inputs:
%   id          - Target identifier
%   ifSel       - Select IF -1,0,+1 => -20/0/+20 MHz
%   bandRev     - Switch band reversal, 0/1 => off/on
%   singleAdc   - Select ADCs to use, 0/1 => both/single ADC
%
% Outputs:
%   cfm         - MsgIdWlan.CfgBandSelCfm
%
% Description:
%   Send IF selection / band reversal and ADC config message, format:
%
%     req = [MsgIdWlan.CfgBandSelReq, ifSel, bandRev, singleAdc]
%
%===============================================================================

  % ----------------------------------------------------------------------------
  % Global defintions
  global MsgIdWlan;
    
  % Define message core
  id.core = 'wlan';
    
  % ----------------------------------------------------------------------------
  % Convert IF selection to proper range
  ifSel = mod(ifSel, 4);    % -1,0,1 -> 3,0,1
  
  % Send message
  req   = [MsgIdWlan.CfgBandSelReq, ifSel, bandRev, singleAdc];
  nCfm  = 1;
  cfm   = sendMsg(id, req, nCfm);
  
  % Debug: check confirm
  if (cfm(1) ~= MsgIdWlan.CfgBandSelCfm)
    fprintf('Error sending band selection config request\n');
    pause
  end

%===============================================================================
