function cfm = msgWlanCfgAgcReq(id, agcRunMode, agcAttnInit)
%===============================================================================
%  Copyright (C) BAY9, 2011
%===============================================================================
%
% Syntax:
%   cfm = msgWlanCfgAgcReq(id, agcRunMode, agcAttnInit)
%
% Inputs:
%   id          - Target identifier
%   agcRunMode  - 1 = fixed gain/ 2 = normal AGC
%   agcAttnInit - Initial / fixed attenuation 0..69
%
% Outputs:
%   cfm     - MsgIdWlan.CfgAgcCfm
%
% Description:
%   Send config AGC message, format:
%
%     req = [MsgIdWlan.CfgAgcReq, agcRunMode, agcAttnInit]
%
%   The agcRunMode determines whether the the AGC should be disabled and remain
%   at the initial value (agcRunMode=1), or work normally (agcRunMode=2).
%
%===============================================================================

  % ----------------------------------------------------------------------------
  % Global defintions
  global MsgIdWlan;
    
  % Define message core
  id.core = 'wlan';
    
  % ----------------------------------------------------------------------------
  % Send message
  req   = [MsgIdWlan.CfgAgcReq, agcRunMode, agcAttnInit];
  nCfm  = 1;
  cfm   = sendMsg(id, req, nCfm);
  
  % Debug: check confirm
  if (cfm(1) ~= MsgIdWlan.CfgAgcCfm)
    fprintf('Error sending AGC config request\n');
    pause
  end

%===============================================================================
