function cfm = msgWlanCfgAcqThrReq(id, thrIdx)
%===============================================================================
%  Copyright (C) BAY9, 2011
%===============================================================================
%
% Syntax:
%   cfm = msgWlanCfgAcqThrReq(id, thrIdx)
%
% Inputs:
%   id      - Target id
%   thrIdx  - -1/0
%
% Outputs:
%   cfm     - MsgIdWlan.CfgAcqThrCfm
%
% Description:
%   Configure the acquisition threshold
%     thrIdx = 0   -> Normal behaviour
%     thrIdx = -1  -> Increased sensitivity with regular false alarm in
%                     presence of WGN. Used for RF calibration only.
%
%===============================================================================

  % ----------------------------------------------------------------------------
  % Global defintions
  global MsgIdWlan;
  
  % Define message core
  id.core = 'wlan';
      
  % ----------------------------------------------------------------------------
  % Send message
  req   = [MsgIdWlan.CfgAcqThrReq, thrIdx];
  nCfm  = 1;
  cfm   = sendMsg(id, req, nCfm);
  
  % Debug: check confirm
  if (cfm(1) ~= MsgIdWlan.CfgAcqThrCfm)
    fprintf('Error sending ACQ threshold config request\n');
    pause
  end

%===============================================================================
