function cfm = msgWlanBootReq(id)
%===============================================================================
%  Copyright (C) BAY9, 2011
%===============================================================================
%
% Syntax:
%   cfm = msgWlanBootReq(id)
%
% Inputs:
%   id    - target identifier
%
% Outputs:
%   --
%
% Description:
%   Boot the WLAN system via UART or external interface.
%   After booting, evaluate the confirm and possibly get the version
%   number.
%
%   Note, this is not really a message although it makes use of the 
%   control interface.
%
%===============================================================================

  % ----------------------------------------------------------------------------
  % Global defintions - call message id file while booting
  global MsgIdWlan;
  
  % Define message core
  id.core = 'wlan';
  
  % ----------------------------------------------------------------------------  
  % Get current boot data file
  fileName  = which(mfilename);
  q         = findstr(fileName, '/');
  q         = q(end-1);
  datDir    = fileName(1:q-1);
  bootFile  = [datDir '/dat/boot.bin'];

  % Read the boot data file
  fid     = fopen(bootFile, 'r');
  bootDat = fread(fid, Inf, 'uint16')';
  fclose(fid);
  
  % Send boot data
  req   = bootDat;
  nCfm  = 1;
  cfm   = sendMsg(id, req, nCfm);

  % ----------------------------------------------------------------------------  
  % Debug only, check confirm
  %  -> send version request, print the version  
  if (cfm == MsgIdWlan.BootCfm)
    fprintf('Booting WLAN OK\n');
  else
    fprintf('Booting WLAN error, cfm = %d\n', cfm);
    pause
  end

%===============================================================================
