function testTx11g(id, numTx, delayTx, modeTx, lenTx, ssTx)
%===============================================================================
%  Copyright (C) BAY9, 2013
%===============================================================================
%
% Syntax:
%   testTx11g(id, numTx, delayTx, modeTx, lenTx, ssTx)
%
% Inputs:
%   id          - Target identifier
%   numTx       - Number of frames to transmit
%   delayTx     - Delay after transmitting a frame in seconds
%   modeTx      - ssTx=0 -> 11a: 0-7 = 6..54 MBit/s
%                 ssTx=1 -> 11b: 1-7 = 1l, 2s, 2l, ..., 11l
%   lenTx       - Frame length in bytes
%   ssTx        - 0 = 11a, 1 = 11b
%
% Outputs:
%   --
%
% Description:
%   Send frames using the internal data generator. The parameters modeTx
%   and  lenTx can be defined as vectors, in this case, the values is
%   chosen randomly from the range. By default, it just sends 100 random
%   frames using target id.inst = 0.
%
%===============================================================================

  % ------------------------------------------------------------------
  % Default idStd
  global idStd;
  if (isempty(idStd))
    idStd.tgt   = 'fpga0';
    idStd.top   = 'wlanX';
    idStd.inst  = 0;
  end

  % ----------------------------------------------------------------------------
  % Check input arguments, possible set some defaults
  if (nargin < 1 || isempty(id))
    id = idStd;
  end
  if (nargin < 2 || isempty(numTx))
    numTx = 10;
  end
  if (nargin < 3 || isempty(delayTx))
    delayTx = 0.01;
  end
  if (nargin < 4 || isempty(modeTx))
    modeTx = [0:7];
  end
  if (nargin < 5 || isempty(lenTx))
    lenTx = [1:4095];
  end
  if (nargin < 6 || isempty(ssTx))
    ssTx = [0:1];
  end
    
  % ----------------------------------------------------------------------------
  % Configure TX settings
  txReqDelay  = 30;
  timerMode   = 1;
    
  % Main loop over frames
  for k = 0:numTx-1

    % Random selection
    modeTxC = modeTx(floor(length(modeTx)*rand)+1);
    lenTxC  = lenTx(floor(length(lenTx)*rand)+1);
    ssTxC   = ssTx(floor(length(ssTx)*rand)+1);

    % Prevent 11b, 1 MBit/s, short header -> switch to long header
    if (modeTxC==0 && ssTxC==1)
      modeTxC = 1;
    end

    % Setup internal data generator + start frame
          msgWlanCfgTxDataSrcReq(id, 1, lenTxC, k);
    cfm = msgWlanTxRun(id, modeTxC+ssTxC*2^15, lenTxC, timerMode, txReqDelay);
    
    % Check return timing
    if (cfm(2) ~= 0)
      fprintf('Error, TX timing incorrect\n');
      keyboard
    end
    
    % Debug print
    if (mod(k, 20)==0)
      fprintf('\n');
      fprintf('+--------+---+---+------+\n');
      fprintf('|   No   | S | M |  Len |\n');
      fprintf('+--------+---+---+------+\n');
    end
    fprintf('| %6d | %d | %d | %4d |\n', k, ssTxC, modeTxC, lenTxC);

    % Wait a moment
    pause(delayTx)

  end

%===============================================================================
