//====================================================================================
//  Copyright (C) BAY9, 2016
//====================================================================================
//
// MODULE:
//   wnrFilt
//
// ----------------------------------------------------------------------------------------
// ----------------------------------------------------------------------------------------

module wnrFilt(y, y_or, y_ff, y_we, 
               x, x_ir, x_fe, x_re, 
               run1, 
               regBus, regWe, regRe, regWeOut, regReOut, clk1, clk2, reset);

  // --------------------------------------------------------------------------------------
  // Module parameters
  parameter y_w               = 0;
  parameter x_w               = 0;

  parameter run1_w            = 0;

  parameter w                 = 0;

  // --------------------------------------------------------------------------------------
  // Inputs and outputs
  output            [y_w-1:0]  y;
  output                       y_or;
  input                        y_ff;
  output                       y_we;
  assign                       y_we = y_or & ~y_ff;

  input             [x_w-1:0]  x;
  output                       x_ir;
  input                        x_fe;
  output                       x_re;
  assign                       x_re = x_ir & ~x_fe;

  input          [run1_w-1:0]  run1;

  // Define clock and reset
  input                        clk1;
  input                        clk2;
  input                        reset;

  // Inputs and outputs for registers
  inout                [15:0]  regBus;
  input                        regWe;
  input                        regRe;
  output                       regWeOut;
  output                       regReOut;

  // Assign clock
  wire clk;
  assign clk = clk1;

  // --------------------------------------------------------------------------------------
  // External status registers
  // --------------------------------------------------------------------------------------
  // Define register control output
  assign regWeOut = 0;
  assign regReOut = 0;

// ----------------------------------------------------------------------------------------
//=========================================================================================

  // --------------------------------------------------------------------------------------
  // Register definitions
  wire signed  [w-1:0] xRe, xIm;
  reg  signed  [w-1:0] xD1Re,  xD1Im,  xD2Re,  xD2Im;
  reg  signed  [w+3:0] xI0Re,  xI0Im,  xI1Re,  xI1Im,  xI2Re,  xI2Im;
  reg  signed  [w+3:0] xI0SRe, xI0SIm, xI1SRe, xI1SIm, xI2SRe, xI2SIm;
  reg  signed  [w+3:0] xI0ARe, xI0AIm, xI1ARe, xI1AIm, xI2ARe, xI2AIm;
  reg  signed  [w+3:0] xSumRe, xSumIm;
  reg  signed  [w-1:0] yRe, yIm;
  
  reg            [4:0] cnt;
  reg                  yOr;
  
  // --------------------------------------------------------------------------------------
  // Assign input enable
  assign x_ir = run1==1 && cnt!=26;
  
  // --------------------------------------------------------------------------------------
  // Signal processing behaviour
  assign xRe = x[  w-1:0];
  assign xIm = x[2*w-1:w];
  
  always @(*) begin
    
    // Assign borders of 26 carrier block, mul by 4
    if (cnt==26) begin
      xI0Re = {{2{xD1Re[w-1]}}, xD1Re, 2'b00};
      xI0Im = {{2{xD1Im[w-1]}}, xD1Im, 2'b00};
    end else begin
      xI0Re = {{2{xRe[w-1]}}, xRe, 2'b00};
      xI0Im = {{2{xIm[w-1]}}, xIm, 2'b00};
    end
    
    xI1Re = {{2{xD1Re[w-1]}}, xD1Re, 2'b00};
    xI1Im = {{2{xD1Im[w-1]}}, xD1Im, 2'b00};
        
    if (cnt==1) begin
      xI2Re = {{2{xD1Re[w-1]}}, xD1Re, 2'b00};
      xI2Im = {{2{xD1Im[w-1]}}, xD1Im, 2'b00};
    end else begin
      xI2Re = {{2{xD2Re[w-1]}}, xD2Re, 2'b00};
      xI2Im = {{2{xD2Im[w-1]}}, xD2Im, 2'b00};
    end
    
    // Multiplication by 1/2/1
    xI0SRe = xI0Re >>> 2;
    xI0SIm = xI0Im >>> 2;
    xI1SRe = xI1Re >>> 1;
    xI1SIm = xI1Im >>> 1;
    xI2SRe = xI2Re >>> 2;
    xI2SIm = xI2Im >>> 2;
    
    // Add up
    xI0ARe = xI0Re + xI0SRe;
    xI0AIm = xI0Im + xI0SIm;
    xI1ARe = xI1Re + xI1SRe;
    xI1AIm = xI1Im + xI1SIm;
    xI2ARe = xI2Re + xI2SRe;
    xI2AIm = xI2Im + xI2SIm;
        
    // Add up the rest (pipeline needed ??)
    xSumRe = xI0ARe + xI1ARe + xI2ARe + 8;
    xSumIm = xI0AIm + xI1AIm + xI2AIm + 8;
  
  end

  // --------------------------------------------------------------------------------------
  // FSM
  always @(posedge clk) begin
    
    // Reset
    if (run1==0) begin
      cnt   <= 0;
      yRe   <= 0;
      yIm   <= 0;
      xD1Re <= 0;
      xD2Re <= 0;
      xD1Im <= 0;
      xD2Im <= 0;
      yOr   <= 0;
            
    // Normal operation
    end else begin
      
      yRe <= xSumRe[w+3:4];
      yIm <= xSumIm[w+3:4];
      
      // Filter state update
      if (x_re) begin
        xD2Re <= xD1Re;
        xD1Re <= xRe;
        xD2Im <= xD1Im;
        xD1Im <= xIm;
      end
      
      // Counter update
      if (x_re) begin
        cnt <= cnt + 1;
      end else
      if (cnt==26) begin
        cnt <= 0;
      end

      // Output ready delay line
      yOr <= (cnt!=0 && x_re) || (cnt==26);
      
    end // if (run1_q==0) ... else
  end // always

  // --------------------------------------------------------------------------------------
  // Assign output enable
  assign y    = {yIm, yRe};
  assign y_or = yOr;
  
endmodule
//=========================================================================================

