//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter wdfSrc_0_x_w             = 24;

  // Outputs
  parameter wdfSrc_0_y_w             = 24;
  parameter wdfSrc_0_y40_w           = 28;

  // Input control lines
  parameter wdfSrc_0_run1_w          = 2;

  // Output control lines

  // Eregs
  parameter wdfSrc_0_cLo1_w          = 12;
  parameter wdfSrc_0_cLo1_r          = 207;
  parameter wdfSrc_0_cLo1_s          = 0;
  parameter wdfSrc_0_cLo2_w          = 12;
  parameter wdfSrc_0_cLo2_r          = 699;
  parameter wdfSrc_0_cLo2_s          = 0;
  parameter wdfSrc_0_cLo3_w          = 12;
  parameter wdfSrc_0_cLo3_r          = 1253;
  parameter wdfSrc_0_cLo3_s          = 0;
  parameter wdfSrc_0_cLo4_w          = 12;
  parameter wdfSrc_0_cLo4_r          = 1776;
  parameter wdfSrc_0_cLo4_s          = 0;
  parameter wdfSrc_0_cHi1_w          = 12;
  parameter wdfSrc_0_cHi1_r          = 290;
  parameter wdfSrc_0_cHi1_s          = 0;
  parameter wdfSrc_0_cHi2_w          = 12;
  parameter wdfSrc_0_cHi2_r          = 1210;
  parameter wdfSrc_0_cHi2_s          = 0;
  parameter wdfSrc_0_singleAdc_w     = 1;
  parameter wdfSrc_0_singleAdc_r     = 0;
  parameter wdfSrc_0_singleAdc_s     = 0;

  // Parameters
  parameter wdfSrc_0_w               = 12;
  parameter wdfSrc_0_we              = 2;
  parameter wdfSrc_0_wc              = 12;

  // Iregs
  parameter wdfSrc_0_R0_w            = 24;
  parameter wdfSrc_0_R0_n            = 1;
  parameter wdfSrc_0_R0_m            = `CLOG2(1);
  parameter wdfSrc_0_R1_w            = 28;
  parameter wdfSrc_0_R1_n            = 1;
  parameter wdfSrc_0_R1_m            = `CLOG2(1);
  parameter wdfSrc_0_R2_w            = 24;
  parameter wdfSrc_0_R2_n            = 1;
  parameter wdfSrc_0_R2_m            = `CLOG2(1);

  // Single ported memories

  // Dual ported memories

  // Fifos

  // Wires
  parameter wdfSrc_0_ySat_w          = 24;
  parameter wdfSrc_0_ySat_or_w       = 1;
  parameter wdfSrc_0_ySat_ff_w       = 1;

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam wdfSrc_0.x_w             = wdfSrc_0_x_w;
  defparam wdfSrc_0.y_w             = wdfSrc_0_y_w;
  defparam wdfSrc_0.y40_w           = wdfSrc_0_y40_w;
  defparam wdfSrc_0.run1_w          = wdfSrc_0_run1_w;
  defparam wdfSrc_0.cLo1_w          = wdfSrc_0_cLo1_w;
  defparam wdfSrc_0.cLo1_r          = wdfSrc_0_cLo1_r;
  defparam wdfSrc_0.cLo1_s          = wdfSrc_0_cLo1_s;
  defparam wdfSrc_0.cLo2_w          = wdfSrc_0_cLo2_w;
  defparam wdfSrc_0.cLo2_r          = wdfSrc_0_cLo2_r;
  defparam wdfSrc_0.cLo2_s          = wdfSrc_0_cLo2_s;
  defparam wdfSrc_0.cLo3_w          = wdfSrc_0_cLo3_w;
  defparam wdfSrc_0.cLo3_r          = wdfSrc_0_cLo3_r;
  defparam wdfSrc_0.cLo3_s          = wdfSrc_0_cLo3_s;
  defparam wdfSrc_0.cLo4_w          = wdfSrc_0_cLo4_w;
  defparam wdfSrc_0.cLo4_r          = wdfSrc_0_cLo4_r;
  defparam wdfSrc_0.cLo4_s          = wdfSrc_0_cLo4_s;
  defparam wdfSrc_0.cHi1_w          = wdfSrc_0_cHi1_w;
  defparam wdfSrc_0.cHi1_r          = wdfSrc_0_cHi1_r;
  defparam wdfSrc_0.cHi1_s          = wdfSrc_0_cHi1_s;
  defparam wdfSrc_0.cHi2_w          = wdfSrc_0_cHi2_w;
  defparam wdfSrc_0.cHi2_r          = wdfSrc_0_cHi2_r;
  defparam wdfSrc_0.cHi2_s          = wdfSrc_0_cHi2_s;
  defparam wdfSrc_0.singleAdc_w     = wdfSrc_0_singleAdc_w;
  defparam wdfSrc_0.singleAdc_r     = wdfSrc_0_singleAdc_r;
  defparam wdfSrc_0.singleAdc_s     = wdfSrc_0_singleAdc_s;
  defparam wdfSrc_0.w               = wdfSrc_0_w;
  defparam wdfSrc_0.we              = wdfSrc_0_we;
  defparam wdfSrc_0.wc              = wdfSrc_0_wc;
  defparam wdfSrc_0.R0_w            = wdfSrc_0_R0_w;
  defparam wdfSrc_0.R0_n            = wdfSrc_0_R0_n;
  defparam wdfSrc_0.R0_m            = wdfSrc_0_R0_m;
  defparam wdfSrc_0.R1_w            = wdfSrc_0_R1_w;
  defparam wdfSrc_0.R1_n            = wdfSrc_0_R1_n;
  defparam wdfSrc_0.R1_m            = wdfSrc_0_R1_m;
  defparam wdfSrc_0.R2_w            = wdfSrc_0_R2_w;
  defparam wdfSrc_0.R2_n            = wdfSrc_0_R2_n;
  defparam wdfSrc_0.R2_m            = wdfSrc_0_R2_m;
  defparam wdfSrc_0.ySat_w          = wdfSrc_0_ySat_w;
  defparam wdfSrc_0.ySat_or_w       = wdfSrc_0_ySat_or_w;
  defparam wdfSrc_0.ySat_ff_w       = wdfSrc_0_ySat_ff_w;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module
  parameter R_wdfSrc_0_cLo1                                              = 0;
  defparam  wdfSrc_0.R_cLo1                                              = R_wdfSrc_0_cLo1;
  parameter R_wdfSrc_0_cLo2                                              = 1;
  defparam  wdfSrc_0.R_cLo2                                              = R_wdfSrc_0_cLo2;
  parameter R_wdfSrc_0_cLo3                                              = 2;
  defparam  wdfSrc_0.R_cLo3                                              = R_wdfSrc_0_cLo3;
  parameter R_wdfSrc_0_cLo4                                              = 3;
  defparam  wdfSrc_0.R_cLo4                                              = R_wdfSrc_0_cLo4;
  parameter R_wdfSrc_0_cHi1                                              = 4;
  defparam  wdfSrc_0.R_cHi1                                              = R_wdfSrc_0_cHi1;
  parameter R_wdfSrc_0_cHi2                                              = 5;
  defparam  wdfSrc_0.R_cHi2                                              = R_wdfSrc_0_cHi2;
  parameter R_wdfSrc_0_singleAdc                                         = 6;
  defparam  wdfSrc_0.R_singleAdc                                         = R_wdfSrc_0_singleAdc;

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire                  [wdfSrc_0_y_w-1:0]  wdfSrc_0_y;
  wire                                      wdfSrc_0_y_or;
  wire                                      wdfSrc_0_y_ff;
  wire                                      wdfSrc_0_y_we;

  wire                [wdfSrc_0_y40_w-1:0]  wdfSrc_0_y40;
  wire                                      wdfSrc_0_y40_or;
  wire                                      wdfSrc_0_y40_ff;
  wire                                      wdfSrc_0_y40_we;

  wire                  [wdfSrc_0_x_w-1:0]  wdfSrc_0_x;
  wire                                      wdfSrc_0_x_ir;
  wire                                      wdfSrc_0_x_fe;
  wire                                      wdfSrc_0_x_re;

  wire               [wdfSrc_0_run1_w-1:0]  wdfSrc_0_run1;

  wire                                      wdfSrc_0_regWe;
  wire                                      wdfSrc_0_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  wdfSrc wdfSrc_0(wdfSrc_0_y, wdfSrc_0_y_or, wdfSrc_0_y_ff, wdfSrc_0_y_we,
                  wdfSrc_0_y40, wdfSrc_0_y40_or, wdfSrc_0_y40_ff, wdfSrc_0_y40_we,
                  wdfSrc_0_x, wdfSrc_0_x_ir, wdfSrc_0_x_fe, wdfSrc_0_x_re, 
                  wdfSrc_0_run1, 
                  regBus, regWe, regRe, wdfSrc_0_regWe, wdfSrc_0_regRe, clk, clk2, reset);


//==============================================================================
