//====================================================================================
//  Copyright (C) BAY9, 2016
//====================================================================================
//
// MODULE:
//   vitBrev
//
// ----------------------------------------------------------------------------------------
// ----------------------------------------------------------------------------------------

module vitBrev(y, y_or, y_ff, y_we, 
               yHdr, yHdr_or, yHdr_ff, yHdr_we, 
               x0, x0_ir, x0_fe, x0_re, 
               x1, x1_ir, x1_fe, x1_re, 
               irqDone, 
               run1, 
               numIn0, 
               regBus, regWe, regRe, regWeOut, regReOut, clk1, clk2, reset);

  // --------------------------------------------------------------------------------------
  // Module parameters
  parameter y_w               = 0;
  parameter yHdr_w            = 0;
  parameter x0_w              = 0;
  parameter x1_w              = 0;

  parameter irqDone_w         = 0;
  parameter run1_w            = 0;
  parameter numIn0_w          = 0;

  // --------------------------------------------------------------------------------------
  // Inputs and outputs
  output            [y_w-1:0]  y;
  output                       y_or;
  input                        y_ff;
  output                       y_we;
  assign                       y_we = y_or & ~y_ff;

  output         [yHdr_w-1:0]  yHdr;
  output                       yHdr_or;
  input                        yHdr_ff;
  output                       yHdr_we;
  assign                       yHdr_we = yHdr_or & ~yHdr_ff;

  input            [x0_w-1:0]  x0;
  output                       x0_ir;
  input                        x0_fe;
  output                       x0_re;
  assign                       x0_re = x0_ir & ~x0_fe;

  input            [x1_w-1:0]  x1;
  output                       x1_ir;
  input                        x1_fe;
  output                       x1_re;
  assign                       x1_re = x1_ir & ~x1_fe;

  output      [irqDone_w-1:0]  irqDone;
  input          [run1_w-1:0]  run1;
  input        [numIn0_w-1:0]  numIn0;

  // Define clock and reset
  input                        clk1;
  input                        clk2;
  input                        reset;

  // Inputs and outputs for registers
  inout                [15:0]  regBus;
  input                        regWe;
  input                        regRe;
  output                       regWeOut;
  output                       regReOut;

  // Assign clock
  wire clk;
  assign clk = clk1;

  // --------------------------------------------------------------------------------------
  // External status registers
  // --------------------------------------------------------------------------------------
  // Define register control output
  assign regWeOut = 0;
  assign regReOut = 0;

// ----------------------------------------------------------------------------------------
//=========================================================================================

  // --------------------------------------------------------------------------------------
  // Register definitions
  reg    [119:0]  x0S;
  reg     [63:0]  x1S;
  reg      [6:0]  cntIn0;
  reg      [5:0]  cntIn1;
  reg      [3:0]  cntOut0;
  reg      [3:0]  cntOut1;

  // --------------------------------------------------------------------------------------
  // Assign input and output enable
  assign x0_ir = run1!=0;
  assign x1_ir = run1!=0;
  
  // --------------------------------------------------------------------------------------
  // FSM
  always @(posedge clk) begin
    
    // Reset
    if (run1==0) begin
      cntIn0  <= numIn0;
      cntIn1  <= 0;
      cntOut0 <= 0;
      cntOut1 <= 0;
      
    // Normal operation
    end else begin
      
      // -------------------------------      
      // Input counter for x0
      if (x0_re) begin
        cntIn0 <= cntIn0-1;
      end
      
      // Output counter for x0
      if (cntIn0==0 & x0_re) begin
        cntOut0 <= (numIn0+1)>>3;
      end else
      if (cntOut0!=0) begin
        cntOut0 <= cntOut0-1;
      end

      // Shift register behaviour for x0
      if (x0_re) begin
        x0S <= {x0S[118:0], x0};
      end else
      if (cntOut0!=0) begin
        x0S[111:0] <= x0S[119:8];
      end

      // -------------------------------      
      // Input counter for x1
      if (x1_re) begin
        cntIn1 <= cntIn1-1;
      end
      
      // Output counter for x1
      if (cntIn1==1 & x1_re) begin
        cntOut1 <= 8;
      end else
      if (cntOut1!=0) begin
        cntOut1 <= cntOut1-1;
      end

      // Shift register behaviour for x1
      if (x1_re) begin
        x1S     <= {x1S[62:0], x1};
      end else
      if (cntOut1!=0) begin
        x1S[55:0] <= x1S[63:8];
      end
      
    end // if (run1==0) ... else
  end // always

  // --------------------------------------------------------------------------------------
  // Assign output
  assign y         = cntOut1!=0 ? x1S[7:0] : x0S[7:0];
  assign y_or      = run1==2 & (cntOut1!=0 | cntOut0!=0);
  
  assign yHdr      = {x0S[22:0], x0};
  assign yHdr_or   = run1==1 & cntIn0==0;

  assign irqDone[0] = run1==1 & cntIn0==0;
  assign irqDone[1] = cntOut0==1;

endmodule
//=========================================================================================

