//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter vitAcs_63_sb_w            = 8;
  parameter vitAcs_63_pmIn0_w         = 9;
  parameter vitAcs_63_pmIn1_w         = 9;

  // Outputs
  parameter vitAcs_63_sel_w           = 1;
  parameter vitAcs_63_pmOut_w         = 9;

  // Input control lines
  parameter vitAcs_63_run1_w          = 1;

  // Output control lines

  // Eregs

  // Parameters
  parameter vitAcs_63_i0              = 0;
  parameter vitAcs_63_i1              = 0;
  parameter vitAcs_63_pbrv            = 412;
  parameter vitAcs_63_ws              = 4;
  parameter vitAcs_63_wp              = 9;

  // Iregs
  parameter vitAcs_63_pmBuf_w         = 9;
  parameter vitAcs_63_pmBuf_n         = 1;
  parameter vitAcs_63_pmBuf_m         = `CLOG2(1);

  // Single ported memories

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam vitAcs_63.sb_w            = vitAcs_63_sb_w;
  defparam vitAcs_63.pmIn0_w         = vitAcs_63_pmIn0_w;
  defparam vitAcs_63.pmIn1_w         = vitAcs_63_pmIn1_w;
  defparam vitAcs_63.sel_w           = vitAcs_63_sel_w;
  defparam vitAcs_63.pmOut_w         = vitAcs_63_pmOut_w;
  defparam vitAcs_63.run1_w          = vitAcs_63_run1_w;
  defparam vitAcs_63.i0              = vitAcs_63_i0;
  defparam vitAcs_63.i1              = vitAcs_63_i1;
  defparam vitAcs_63.pbrv            = vitAcs_63_pbrv;
  defparam vitAcs_63.ws              = vitAcs_63_ws;
  defparam vitAcs_63.wp              = vitAcs_63_wp;
  defparam vitAcs_63.pmBuf_w         = vitAcs_63_pmBuf_w;
  defparam vitAcs_63.pmBuf_n         = vitAcs_63_pmBuf_n;
  defparam vitAcs_63.pmBuf_m         = vitAcs_63_pmBuf_m;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire               [vitAcs_63_sel_w-1:0]  vitAcs_63_sel;
  wire                                      vitAcs_63_sel_or;
  wire                                      vitAcs_63_sel_ff;
  wire                                      vitAcs_63_sel_we;

  wire             [vitAcs_63_pmOut_w-1:0]  vitAcs_63_pmOut;
  wire                                      vitAcs_63_pmOut_or;
  wire                                      vitAcs_63_pmOut_ff;
  wire                                      vitAcs_63_pmOut_we;

  wire                [vitAcs_63_sb_w-1:0]  vitAcs_63_sb;
  wire                                      vitAcs_63_sb_ir;
  wire                                      vitAcs_63_sb_fe;
  wire                                      vitAcs_63_sb_re;

  wire             [vitAcs_63_pmIn0_w-1:0]  vitAcs_63_pmIn0;
  wire                                      vitAcs_63_pmIn0_ir;
  wire                                      vitAcs_63_pmIn0_fe;
  wire                                      vitAcs_63_pmIn0_re;

  wire             [vitAcs_63_pmIn1_w-1:0]  vitAcs_63_pmIn1;
  wire                                      vitAcs_63_pmIn1_ir;
  wire                                      vitAcs_63_pmIn1_fe;
  wire                                      vitAcs_63_pmIn1_re;

  wire              [vitAcs_63_run1_w-1:0]  vitAcs_63_run1;

  wire                                      vitAcs_63_regWe;
  wire                                      vitAcs_63_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  vitAcs vitAcs_63(vitAcs_63_sel, vitAcs_63_sel_or, vitAcs_63_sel_ff, vitAcs_63_sel_we,
                   vitAcs_63_pmOut, vitAcs_63_pmOut_or, vitAcs_63_pmOut_ff, vitAcs_63_pmOut_we,
                   vitAcs_63_sb, vitAcs_63_sb_ir, vitAcs_63_sb_fe, vitAcs_63_sb_re, 
                   vitAcs_63_pmIn0, vitAcs_63_pmIn0_ir, vitAcs_63_pmIn0_fe, vitAcs_63_pmIn0_re, 
                   vitAcs_63_pmIn1, vitAcs_63_pmIn1_ir, vitAcs_63_pmIn1_fe, vitAcs_63_pmIn1_re, 
                   vitAcs_63_run1, 
                   regBus, regWe, regRe, vitAcs_63_regWe, vitAcs_63_regRe, clk, clk2, reset);


//==============================================================================
