//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter vitAcs_61_sb_w            = 8;
  parameter vitAcs_61_pmIn0_w         = 9;
  parameter vitAcs_61_pmIn1_w         = 9;

  // Outputs
  parameter vitAcs_61_sel_w           = 1;
  parameter vitAcs_61_pmOut_w         = 9;

  // Input control lines
  parameter vitAcs_61_run1_w          = 1;

  // Output control lines

  // Eregs

  // Parameters
  parameter vitAcs_61_i0              = 0;
  parameter vitAcs_61_i1              = 1;
  parameter vitAcs_61_pbrv            = 412;
  parameter vitAcs_61_ws              = 4;
  parameter vitAcs_61_wp              = 9;

  // Iregs
  parameter vitAcs_61_pmBuf_w         = 9;
  parameter vitAcs_61_pmBuf_n         = 1;
  parameter vitAcs_61_pmBuf_m         = `CLOG2(1);

  // Single ported memories

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam vitAcs_61.sb_w            = vitAcs_61_sb_w;
  defparam vitAcs_61.pmIn0_w         = vitAcs_61_pmIn0_w;
  defparam vitAcs_61.pmIn1_w         = vitAcs_61_pmIn1_w;
  defparam vitAcs_61.sel_w           = vitAcs_61_sel_w;
  defparam vitAcs_61.pmOut_w         = vitAcs_61_pmOut_w;
  defparam vitAcs_61.run1_w          = vitAcs_61_run1_w;
  defparam vitAcs_61.i0              = vitAcs_61_i0;
  defparam vitAcs_61.i1              = vitAcs_61_i1;
  defparam vitAcs_61.pbrv            = vitAcs_61_pbrv;
  defparam vitAcs_61.ws              = vitAcs_61_ws;
  defparam vitAcs_61.wp              = vitAcs_61_wp;
  defparam vitAcs_61.pmBuf_w         = vitAcs_61_pmBuf_w;
  defparam vitAcs_61.pmBuf_n         = vitAcs_61_pmBuf_n;
  defparam vitAcs_61.pmBuf_m         = vitAcs_61_pmBuf_m;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire               [vitAcs_61_sel_w-1:0]  vitAcs_61_sel;
  wire                                      vitAcs_61_sel_or;
  wire                                      vitAcs_61_sel_ff;
  wire                                      vitAcs_61_sel_we;

  wire             [vitAcs_61_pmOut_w-1:0]  vitAcs_61_pmOut;
  wire                                      vitAcs_61_pmOut_or;
  wire                                      vitAcs_61_pmOut_ff;
  wire                                      vitAcs_61_pmOut_we;

  wire                [vitAcs_61_sb_w-1:0]  vitAcs_61_sb;
  wire                                      vitAcs_61_sb_ir;
  wire                                      vitAcs_61_sb_fe;
  wire                                      vitAcs_61_sb_re;

  wire             [vitAcs_61_pmIn0_w-1:0]  vitAcs_61_pmIn0;
  wire                                      vitAcs_61_pmIn0_ir;
  wire                                      vitAcs_61_pmIn0_fe;
  wire                                      vitAcs_61_pmIn0_re;

  wire             [vitAcs_61_pmIn1_w-1:0]  vitAcs_61_pmIn1;
  wire                                      vitAcs_61_pmIn1_ir;
  wire                                      vitAcs_61_pmIn1_fe;
  wire                                      vitAcs_61_pmIn1_re;

  wire              [vitAcs_61_run1_w-1:0]  vitAcs_61_run1;

  wire                                      vitAcs_61_regWe;
  wire                                      vitAcs_61_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  vitAcs vitAcs_61(vitAcs_61_sel, vitAcs_61_sel_or, vitAcs_61_sel_ff, vitAcs_61_sel_we,
                   vitAcs_61_pmOut, vitAcs_61_pmOut_or, vitAcs_61_pmOut_ff, vitAcs_61_pmOut_we,
                   vitAcs_61_sb, vitAcs_61_sb_ir, vitAcs_61_sb_fe, vitAcs_61_sb_re, 
                   vitAcs_61_pmIn0, vitAcs_61_pmIn0_ir, vitAcs_61_pmIn0_fe, vitAcs_61_pmIn0_re, 
                   vitAcs_61_pmIn1, vitAcs_61_pmIn1_ir, vitAcs_61_pmIn1_fe, vitAcs_61_pmIn1_re, 
                   vitAcs_61_run1, 
                   regBus, regWe, regRe, vitAcs_61_regWe, vitAcs_61_regRe, clk, clk2, reset);


//==============================================================================
